(in-package "ACL2")

;Note:  There's now a separate expt-proofs book

(local (include-book "expt2-proofs"))
(include-book "negative-syntaxp")
(include-book "fl2")

(in-theory (disable expt))

;there's a distinction between expt and expt-2 rules

;add expt-monotone rules

;todo: 
; make consistent names
;  expt vs. expt2   

;see also a14
;generalize?  use arith books?
;this event is copied in irepsproofs.lisp
(defthm expt-2-positive-rational-type
  (and (rationalp (expt 2 i))
       (< 0 (expt 2 i)))
  :rule-classes ((:type-prescription :typed-term (expt 2 i))))

(defthm expt-2-positive-integer-type
  (implies (<= 0 i)
           (and (integerp (expt 2 i))
                (< 0 (expt 2 i))))
  :rule-classes (:type-prescription))

;the rewrite rule counterpart to expt-2-positive-integer-type
(defthm expt-2-integerp
  (implies (<= 0 i)
           (integerp (expt 2 i))))

(defthm expt-2-type-linear
  (implies (<= 0 i)
           (<= 1 (expt 2 i)))
  :rule-classes ((:linear :trigger-terms ((expt 2 i)))))

(defthm expt-0-i
  (implies (and (case-split (integerp i))      ;since expt with a non-integer index is 1
                (case-split (not (equal 0 i))) ;since (expt 0 0) is 1
                )
           (equal (expt 0 i)
                  0)))

(defthm expt-r-0
  (equal (expt r 0)
         1)

)

;gen
;drop -rewrite from the name?
;split off the non-integer case
;loops with defn expt - add theory invariant
;gen
;split off the non-integer case
(defthm expt-split
  (implies (and (integerp i1)
                (integerp i2)
                (case-split (acl2-numberp r))
                (case-split (not (equal r 0)))
                )
           (equal (expt r (+ i1 i2))
                  (* (expt r i1)
                     (expt r i2)))))


(in-theory (disable expt-split))

;We could disable this if it causes problems (but it seems okay).
;should always use case-split n hyps that say exponents are integers
(defthm expt-with-i-non-integer
  (implies (not (integerp i))
           (equal (expt r i)
                  1)))

;loops with expt-inverse. which is better?
;i'd rather have the inverting outside expt since most rules don't look inside expt???
;disable this since have -gen version below
(defthm expt-pull-negation-out-of-power-helper
  (equal (expt r (* -1 i))
         (/ (expt r i))))

(in-theory (disable expt-pull-negation-out-of-power-helper)) ;this gets enabled somewhere (WHY?)

(defthm expt-pull-negation-out-of-power
  (implies (syntaxp (negative-syntaxp i))
           (equal (expt r i)
                  (/ (expt r (* -1 i))))))

; add to theory-invariant table
(defthm expt-pull-negation-into-power
  (equal (/ (expt r i))
         (expt r (* -1 i))))

(in-theory (disable expt-pull-negation-into-power))


;when you disable either of the two rules below, you might have to disable expt-compare?
;took these rules out of :rewrite since we have expt-compare?
;are these bad :linear rules because they have free vars?
;change name - no longer linear
(DEFTHM EXPT-MONOTONE-linear-eric
  (IMPLIES (AND (<= i j)
                (case-split (INTEGERP i))
                (case-split (INTEGERP j))
                )
           (<= (EXPT 2 i) (EXPT 2 j)))
  :RULE-CLASSES nil
;(;:rewrite 
 ;(:linear :trigger-terms ((expt 2 i))))
)

;change name - no longer linear
(DEFTHM EXPT-strong-MONOTONE-linear-eric
  (IMPLIES (AND  (< i j)
                 (case-split (INTEGERP i))
                 (case-split (INTEGERP j)))
           (< (EXPT 2 i) (EXPT 2 j)))
  :RULE-CLASSES NIL
  ;(;:rewrite 
   ;              (:linear :trigger-terms ((expt 2 i))))
)


#|
(defthm expt-next
  (implies (and (integerp i1)
                (integerp i2)
                (< (expt 2 i1) (expt 2 i2)))
           (<= (expt 2 i1) (expt 2 (+ -1 i2)))))

(in-theory (disable expt-next))
|#





;expt-compare
;handle constants as args?
(defthm expt2-1-to-1
  (implies (and (integerp i1)
                (integerp i2))
           (equal (equal (expt 2 i1) (expt 2 i2))
                  (equal i1 i2))))


;could gen? move hyps to concl?
(defthm expt-even
  (implies (and (case-split (integerp i))
                (< 0 i))
           (INTEGERP (* 1/2 (EXPT 2 i)))))


;generalize rules like this with a power2-syntaxp (not power2p!) ?
;make conclusion an equality?
(defthm expt-quotient-integerp
  (implies (and (case-split (integerp i))
                (case-split (integerp j))
                (<= j i))
           (integerp (* (expt 2 i) (/ (expt 2 j)))))
  :rule-classes (:rewrite :type-prescription))

(defthm expt-quotient-integerp-alt
  (implies (and (case-split (integerp i))
                (case-split (integerp j))
                (<= j i))
           (integerp (* (/ (expt 2 j)) (expt 2 i))))
  :rule-classes (:rewrite :type-prescription)
)



;which way do we want to do this?
;disable later?
;add a "can have a 2 multiplied in" hyp to this series?











;defined here just so I can disable it?
(defthm expt-inverse
    (implies (integerp n)
	     (equal (/ (expt 2 n))
		    (expt 2 (- n)))))

(in-theory (disable expt-inverse))







;from sse-div proof

;is there a 2 term version?
(defthm expt-prod-integer-3-terms
  (implies (and (integerp i)
                (integerp j)
                (<= 0 (+ i j))
                (integerp n))
           (integerp (* (expt 2 i) (expt 2 j) n))))

;drop these?
;generalize to comparisons to any constant (any power of 2)?










;improve to handle n non-integer?
(defthm expt2-integer
  (implies (case-split (integerp i))
           (equal (integerp (expt 2 i))
                  (<= 0 i))))

;bad name?
(defthm expt2-inverse-integer
  (implies (case-split (integerp i))
           (equal (INTEGERP (/ (EXPT 2 i)))
                  (<= i 0))))




;figure out a better solution to this problem
;perhaps say if a term is a power of 2, then it's an integer iff its expo is >=0
(defthm expt-prod-integer-3-terms-2
  (implies (and (integerp i)
                (integerp j)
                (integerp l)
                (<= 0 (+ i (- j) (- l)))
                )
           (integerp (* (expt 2 i) (/ (expt 2 j)) (/ (expt 2 l))))))

#| would be nice (use expt2-1-to-1)?
(defthm expt2-equal-1
  (implies (integerp i)
           (equal (EQUAL (EXPT 2 i) 1)
                  (equal i 0)))
;  :rule-classes nil
  :hints (("Goal" :in-theory (enable expt-split-rewrite)))
)
|#

(defthm expt2-inverse-even
  (implies (case-split (integerp i))
           (equal (INTEGERP (* 1/2 (/ (EXPT 2 i))))
                  (<= (+ 1 i) 0)))
  :otf-flg t
)



;==== A scheme for preventing massively expensive calls to expt =======

#|
When ACL2 encounters a function call with constant arguments, the simplifier just evaluates the function on
those arguments.  However, calls of (expt r i) with huge i can be very expensive to compute.  (I suppose calls
with huge r might be very expensive too, but in my work, r is almost always 2.)  The scheme below prevents
(expt r i) from being evaluated when i is too large (but allows evaluation in the case of small i).

|#

(in-theory (disable (:executable-counterpart expt)))

(set-compile-fns t)
(defun expt-execute (r i) (expt r i))

;Allows expt calls with small exponents to be computed  
;You can change 1000 to your own desired bound.
(defthm expt-execute-rewrite
  (implies (and (syntaxp (and (quotep r) (quotep i) (< (abs (cadr i)) 1000))))
           (equal (expt r i)
                  (expt-execute r i))))


#|
The rules below are not complete, I proved them as needed to simplify terms like:
(* x
   (EXPT 2 1000001)
   (/ (EXPT 2 1000000))
   y)
|#

(defthm expt2-constants-collect-special-1
  (implies (and (syntaxp (and (quotep i1) (quotep i2))) 
                (case-split (rationalp x))
                (case-split (rationalp y))
                (case-split (integerp i1))
                (case-split (integerp i2)))
           (equal  (* x
                      (EXPT 2 i1)
                      (/ (EXPT 2 i2))
                      y)
                   (* (expt 2 (- i1 i2)) x y))))

(defthm expt2-constants-collect-special-2
  (implies (and (syntaxp (and (quotep i1) (quotep i2))) 
                (case-split (rationalp x))
                (case-split (integerp i1))
                (case-split (integerp i2)))
           (equal  (* x
                      (EXPT 2 i1)
                      (/ (EXPT 2 i2))
                      )
                   (* (expt 2 (- i1 i2)) x))))

(defthm expt2-constants-collect-special-3
  (implies (and (syntaxp (and (quotep i1) (quotep i2))) 
                (case-split (rationalp x))
                (case-split (integerp i1))
                (case-split (integerp i2)))
           (equal (equal (* x (EXPT 2 i1)) (EXPT 2 i2))
                  (equal x (expt 2 (- i2 i1))))))


(defthm expt2-constants-collect-special-4
  (implies (and (syntaxp (and (quotep i1) (quotep i2))) 
                (case-split (rationalp x))
                (case-split (rationalp y))
                (case-split (integerp i1))
                (case-split (integerp i2)))
           (equal  (* x (/ (EXPT 2 i2)) (EXPT 2 i1) y)
                   (* (expt 2 (- i1 i2)) x y))))

(defthm expt2-constants-collect-special-5
  (implies (and (syntaxp (and (quotep i1) (quotep i2))) 
                (case-split (rationalp x))
                (case-split (integerp i1))
                (case-split (integerp i2)))
           (equal  (* x (/ (EXPT 2 i2)) (EXPT 2 i1))
                   (* (expt 2 (- i1 i2)) x))))

(defthm expt2-constants-collect-special-6
  (implies (and (syntaxp (and (quotep i1) (quotep i2))) 
                (case-split (rationalp x))
                (case-split (integerp i1))
                (case-split (integerp i2)))
           (equal  (* (EXPT 2 i2) x (EXPT 2 i1))
                   (* (expt 2 (+ i1 i2)) x))))


;==================================================================

#|
;remove?
(defthm expt-simp
  (implies (integerp x)
           (equal (* 2 (EXPT 2 (+ -1 x)))
                  (expt 2 x)))
  :hints (("Goal" :use (:instance a15 (i 2) (j1 1) (j2 (+ -1 x))))))
|#

;This rule, together with expt-compare allows any comparison using <, >, <=, or >= of two terms which have the
;form of powers of 2 to be rewritten to a claim about the exponents
;can kill more specialized rules
;(DEFTHM EXPO-EXPT2-I
 ; (EQUAL (EXPO (EXPT 2 I))
  ;       (IF (INTEGERP I) I 0))

;)



;loops with a15?
; (expt (* 2 i)) was matching with (expt 2 0) (booo!) so I added the syntaxp hyp
(defthm expt-2-split-product-index
  (implies (and (syntaxp (not (quotep i)))
                (case-split (rationalp r))
                (case-split (integerp i)))
           (equal (expt r (* 2 i))
                  (* (expt r i) (expt r i))))
)
(in-theory (disable expt-2-split-product-index))


(defthm expt-bigger-than-i
  (implies (integerp i)
           (< i (expt 2 i)))

  )

;this might loop with expt-split-rewrite
(defthm expt-compare-with-double
  (implies (and (integerp x)
                (integerp i))
           (equal (< (* 2 x) (expt 2 i))
                  (< x (expt 2 (+ -1 i)))))

)

(in-theory (disable expt-compare-with-double))

(defthm expt-2-reduce-leading-constant-gen
  (implies (case-split (integerp (+ k d)))
           (equal (expt 2 (+ k d))
                  (* (expt 2 (fl k)) (expt 2 (+ (mod k 1) d))))))
(in-theory (disable expt-2-reduce-leading-constant-gen))

;handles the case when k isn't even an integer!
;loops with a15!
(defthm expt-2-reduce-leading-constant
  (implies (and (syntaxp (and (quotep k)
                         (or (>= (cadr k) 1) (< (cadr k) 0))))
                (case-split (integerp (+ k d)))
                )
           (equal (expt 2 (+ k d))
                  (* (expt 2 (fl k)) (expt 2 (+ (mod k 1) d))))))
(in-theory (disable expt-2-reduce-leading-constant))

;better than a15
(DEFTHM expt-combine
  (IMPLIES (AND (case-split (RATIONALP r))
                (case-split (NOT (EQUAL r 0)))
                (case-split (INTEGERP i1))
                (case-split (INTEGERP i2)))
           (AND (EQUAL (* (EXPT r i1) (EXPT r i2))
                       (EXPT r (+ i1 i2)))
                (EQUAL (* (EXPT r i1) (* (EXPT r i2) X))
                       (* (EXPT r (+ i1 i2)) X))))
)
(in-theory (disable expt-combine))


(defthm a15
  (implies (and (rationalp i)
                (not (equal i 0))
                (integerp j1)
                (integerp j2))
           (and (equal (* (expt i j1) (expt i j2))
                       (expt i (+ j1 j2)))
                (equal (* (expt i j1) (* (expt i j2) x))
                       (* (expt i (+ j1 j2)) x)))))
(in-theory (disable a15))

(defthm a16
  (equal (expt (* a b) i)
         (* (expt a i) (expt b i)))
)

#|
(defthm a14
  (and
   (implies (and (integerp i)
                 (<= 0 i)
                 (<= 0 j))
            (and (integerp (expt i j))
                 (<= 0 (expt i j))))
   (implies (and (rationalp i)
                 (not (equal i 0)))
            (not (equal (expt i j) 0))))
  :hints
  (("Goal" :in-theory (enable expt)))
  :rule-classes
  ((:type-prescription
    :corollary
    (implies (and (integerp i)
                  (<= 0 i)
                  (<= 0 j))
             (and (integerp (expt i j))
                  (<= 0 (expt i j)))))
   (:type-prescription
    :corollary
    (implies (and (rationalp i)
                  (not (equal i 0)))
             (not (equal (expt i j) 0))))))

|#

(defthm expt-with-small-n
  (implies (<= n 0)
           (<= (expt 2 n) 1))
  :rule-classes (:linear)
)

