(in-package "ACL2")

#|

  final-theorem.lisp
  ~~~~~~~~~~~~~~~~~~

We prove the final theorem about qsort here. After all that I had to do, this
should go like a breeze, except (maybe) for the hiccup when (length x) is equal
to 0. But this is not a big deal.

We mark the final theorem by a capital DEFTHM for easy look-up.

|#

(include-book "sort-qs-properties")

(local
(include-book "load-extract")
)

(local
(in-theory (disable alloc-qs load-qs))
)

(local
(in-theory (enable in-situ-equal-intermediate
                   intermediate-in-situ-qsort-equal-qsort))
)

(local
(defthm arith-001
  (implies (and (not (natp (1- l)))
                (natp l))
           (equal l 0))
  :rule-classes :forward-chaining)
)

(local
(defthm len-0-implies-not-consp
  (implies (equal (len x) 0)
           (not (consp x)))
  :hints (("Goal"
           :in-theory (enable len)))
  :rule-classes :forward-chaining)
)

(DEFTHM qsort-is-correct
  (implies (true-listp x)
           (equal (qsort x)
                  (isort x)))
  :hints (("Goal"
           :in-theory (disable natp-posp--1) ; needed for v2-8
           :cases ((not (natp (1- (len x))))))))

          
           
