/*****************************************************************************
 *                                                                           *
 * Copyright (c) 2003-2006 Intel Corporation.                                *
 * All rights reserved.                                                      *
 *                                                                           *
 *****************************************************************************

This code is covered by the Community Source License (CPL), version
1.0 as published by IBM and reproduced in the file "license.txt" in the
"license" subdirectory. Redistribution in source and binary form, with
or without modification, is permitted ONLY within the regulations
contained in above mentioned license.

Use of the name and trademark "Intel(R) MPI Benchmarks" is allowed ONLY
within the regulations of the "License for Use of "Intel(R) MPI
Benchmarks" Name and Trademark" as reproduced in the file
"use-of-trademark-license.txt" in the "license" subdirectory. 

THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR
CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT
LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is
solely responsible for determining the appropriateness of using and
distributing the Program and assumes all risks associated with its
exercise of rights under this Agreement, including but not limited to
the risks and costs of program errors, compliance with applicable
laws, damage to or loss of data, programs or equipment, and
unavailability or interruption of operations.

EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER RECIPIENT NOR
ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING
WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OR
DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED
HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 

EXPORT LAWS: THIS LICENSE ADDS NO RESTRICTIONS TO THE EXPORT LAWS OF
YOUR JURISDICTION. It is licensee's responsibility to comply with any
export regulations applicable in licensee's jurisdiction. Under
CURRENT U.S. export regulations this software is eligible for export
from the U.S. and can be downloaded by or otherwise exported or
reexported worldwide EXCEPT to U.S.  embargoed destinations which
include Cuba, Iraq, Libya, North Korea, Iran, Syria, Sudan,
Afghanistan and any other country to which the U.S. has embargoed
goods and services.

 ***************************************************************************

For more documentation than found here, see

[1] doc/ReadMe_IMB.txt 

[2] Intel (R) MPI Benchmarks
    Users Guide and Methodology Description
    In 
    doc/IMB_ug.pdf
    
 File: IMB_cpu_exploit.c 

 Implemented functions: 

 IMB_cpu_exploit;


 ***************************************************************************/


#include "IMB_declare.h"

void IMB_cpu_exploit(float target_secs, int initialize)
/*

                      
                      Runs a CPU intensive code (matrix multiply) for a
                      user defined amount of CPU time
                      


Input variables: 

-target_secs          (type float)                      
                      That many seconds (about) the matrix multiply is run
                      

-initialize           (type int)                      
                      1/0 for first / subsequent calls. If 1, the program
                      determines how to run in order to achieve target CPU time.
                      


*/
{
/*
in: target_secs: desired runtime (about) of the current call
    initialize: 1/0 for first/following call with this value of target_secs
*/

#define SIZE 100
static float a[SIZE][SIZE], x[SIZE], y[SIZE];
double t1,t2;
static int Nrep, target_reps;
int i,j,repeat;

if( target_secs <= 0. ) return;

if( MFlops < 0. )
{
for(i=0; i< SIZE; i++)
  {
  x[i] = y[i] = 0.;
  for(j=0; j< SIZE; j++)
  a[i][j] = 1.;
  }
Nrep =  (50000000/(2*SIZE*SIZE))+1;
t1 = MPI_Wtime();
for( repeat=0; repeat<Nrep; repeat++) {
for (i=0; i<SIZE; i++)
    {
   for (j=0; j<SIZE; j++)
     x[i] = x[i] + a[i][j]*y[j];
    }
}
t2 = MPI_Wtime();

MFlops = (Nrep*2*SIZE*SIZE)*1.e-6/(t2-t1);
Nrep = (int)(1./(t2-t1)*Nrep);
target_reps = 0;

}

if( initialize )
{
target_reps = max(1,(int)(target_secs*Nrep));
t1 = MPI_Wtime();

for( repeat=0; repeat < target_reps; repeat++ )

for (i=0; i<SIZE; i++)
    {
   for (j=0; j<SIZE; j++)
     x[i] = x[i] + a[i][j]*y[j];
    }
t2 = MPI_Wtime();

tCPU = 1000000.*(t2-t1);
}
else
{
for( repeat=0; repeat < target_reps; repeat++ )

for (i=0; i<SIZE; i++)
    {
   for (j=0; j<SIZE; j++)
     x[i] = x[i] + a[i][j]*y[j];
    }
}

}
