#include <stdio.h>
#define WriteLine() printf("\n");
#define WriteLong(x) printf(" %lld", x);
#define ReadLong(a) if (fscanf(stdin, "%lld", &a) != 1) a = 0;
#define long long long

struct _align {
   struct _align_row {
      long col[11];
   } row[11];
} align;

struct _costs {
   struct _costs_row {
      long col[4];
   } row[4];
} costs;

long gap_cost;

long seqA[10];
long seqB[10];

void print_align() {
   long i;
   long j;

   i = 0;
   while(i < 11) {
      j = 0;
      while(j < 11) {
         WriteLong(align.row[i].col[j]);
         j = j+1;
      }
      WriteLine();
      i = i+1;
   }

   WriteLine();
   WriteLong(align.row[10].col[10]);
   WriteLine();
}

void init_costs() {
   long i;
   long j;

   gap_cost = 1;

   i = 0;
   while(i < 4) {
      j = 0;
      while(j < 4) {
         if(i == j) {
            costs.row[1].col[j] = 0;
         }
         else {
            costs.row[i].col[j] = 1;
         }
         j = j+1;
      }
      i = i+1;
   }
}

void init_seqs() {
   seqA[0] = 1;
   seqA[1] = 3;
   seqA[2] = 2;
   seqA[3] = 0;
   seqA[4] = 1;
   seqA[5] = 2;
   seqA[6] = 0;
   seqA[7] = 2;
   seqA[8] = 1;
   seqA[9] = 2;

   seqB[0] = 1;
   seqB[1] = 3;
   seqB[2] = 2;
   seqB[3] = 0;
   seqB[4] = 2;
   seqB[5] = 1;
   seqB[6] = 2;
   seqB[7] = 0;
   seqB[8] = 3;
   seqB[9] = 0;
}

void do_align() {
   long i;
   long j;

   long gapA;
   long gapB;
   long sub;

   long min_gap;
   long min;

   align.row[0].col[0] = 0;
   i = 1;
   while(i < 11) {
      align.row[i].col[0] =
         align.row[i-1].col[0] + gap_cost;
      i = i+1;
   }

   j = 1;
   while(j < 11) {
      align.row[0].col[j] =
         align.row[0].col[j-1] + gap_cost;
      j = j+1;
   }

   i = 1;
   while(i < 11) {
      j = 1;
      while(j < 11) {

         gapA = align.row[i].col[j-1] + gap_cost;
         gapB = align.row[i-1].col[j] + gap_cost;
         sub = align.row[i-1].col[j-1] + costs.row[seqA[i]].col[seqB[j]];

         if(gapA < gapB) {
            min_gap = gapA;
         }
         else {
            min_gap = gapB;
         }

         if(min_gap < sub) {
            min = min_gap;
         }
         else {
            min = sub;
         }

         align.row[i].col[j] = min;

         j = j+1;
      }
      i = i+1;
   }
}

void main() {
   init_costs();
   init_seqs();
   do_align();
   print_align();
}
