/**
 * Quicksort. 
 */
#include <stdio.h>
#define WriteLine() printf("\n");
#define WriteLong(x) printf(" %lld", x);
#define ReadLong(a) if (fscanf(stdin, "%lld", &a) != 1) a = 0;
#define long long long

const long N = 25;
long numbers[25]; /* can't write numbers[N] at file scope */

void initNumbers() {
    long i;

    i = 0;
    while (i < N) {
        numbers[i] = N - i - 1;
        i = i + 1;
    }
}

void swap(long a, long b) {
    long tmp;

    tmp = numbers[a];
    numbers[a] = numbers[b];
    numbers[b] = tmp;
}

void quicksort(long i, long j) {
    
    long index, pivot, ii;
    
    if (i < j) {
        pivot = numbers[i];
        index = i + 1; /* start swapping elements to here (after pivot) */
        ii = index;
        while (ii < j) {
            if (numbers[ii] <= pivot) {
                swap(ii, index);
                index = index + 1;
            }
            
            ii = ii + 1;
        }

        swap(i, index - 1); /* move pivot to middle of subarray */
        
        quicksort(i, index - 1);
        quicksort(index, j);
    }
}

void main() {
    long i;

    initNumbers();

    quicksort(0, N);

    /* print out results */
    i = 0;
    while (i < N) {
        WriteLong(numbers[i]);
        WriteLine();
        i = i + 1;
    }
}
