;;;; -*- Mode:Lisp; Package:CL-USER; Syntax:COMMON-LISP; Base:10 -*-

#-GCL (in-package :CL-USER)
#+GCL (in-package :USER)

;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; Copyright (c) 1996 by Micheal Scott Hewett
;;;
;;; This code may be used by anyone for any project, but may not
;;; be sold in source or object form without permission.
;;; If in doubt, follow the GNU "copyleft" guidelines.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; (Contact: hewett@cs.utexas.edu or hewett@cs.stanford.edu)
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;;
;;;  Definitions of packages for the Web Frame Browser
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

;;; GCL doesn't define the CL-USER package, so we define it here
;;; for CLTL2 compatibility.

(unless (find-package :Common-Lisp)
  (rename-package :Lisp :Lisp
                  (union '("COMMON-LISP" "CL") (package-nicknames (find-package :Lisp))
			 :test #'string-equal) ) )

(unless (find-package :COMMON-LISP-USER)
    (rename-package :User :User (union '("COMMON-LISP-USER" "CL-USER")
				       (package-nicknames (find-package :User))
				       :test #'string-equal) ) )



;;; --- now, on to the WFB stuff

;;; Algernon Abstract Machine package
(if (find-package :WFB)
  (format t "~%Redefining 'WFB' package.")
  ;;ELSE
  (format t "~%Defining 'WFB' package.")
  )

#-GCL
(defpackage "WFB"
  (:use     "COMMON-LISP")
  (:export  "DEF-RULE"
            "MAKE-RULE"
            "AAM-COMPILE"
            "AAM-COMPILE-RULE"
            "AAM-PROCESS"
            "PC"
            "RULE-PC"
            "TRACE-AAM"
            "UNTRACE-AAM"
            "TRACE-RULE"
            "UNTRACE-RULE"
            "UNTRACE-RULES"
            "WITH-AAM-SILENT"
            )
  )


#+GCL
(unless (find-package :WFB)
  (make-package "WFB"
		:use      (list (find-package :LISP)))
  )


;;; For GCL, See 'export' function 
