;;;; -*- Mode:Lisp; Package:CL-USER; Syntax:COMMON-LISP; Base:10 -*-

#-GCL (in-package :CL-USER)
#+GCL (in-package :USER)

;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; Copyright (c) 1996 by Micheal Scott Hewett
;;;
;;; This code may be used by anyone for any project, but may not
;;; be sold in source or object form without permission.
;;; If in doubt, follow the GNU "copyleft" guidelines.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; (Contact: hewett@cs.utexas.edu or hewett@cs.stanford.edu)
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;;
;;;  Definitions of the Web Frame Browser system
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


(defparameter *WFB-HOME* "/u/www/users/qr/algy/browser/reference/wfb")

(defparameter *wfb-source-file-suffix*  ".lisp")
(defparameter *wfb-object-file-suffix*  ".fasl")

(defparameter *ALL-WFB-FILES*

    '("package"		;; Set up the required package(s).
      "wfb-network"     ;; network setup routines.
      "wfb-interface"   ;; client-server routines.
      "version"	        ;; Load the version number.
      ))



;;; ---------------  USEFUL FUNCTIONS  -------------------


(defun load-or-compile-wfb ()

  (compile-wfb)   ;; only compiles if necessary
  (format *trace-output* "~2%Loading the Web Frame Browser")
  (load-wfb)
  )


;;; COMPILE-WFB

(defun compile-wfb ()

  ;; Compile WFB

  (dolist (filename *ALL-WFB-FILES*)
    (compile-wfb-file filename))
  )


;;; File name functions ---------------

(defun wfb-source-file-name (file)
  (concatenate 'string *wfb-home* "/" file *wfb-source-file-suffix*)
  )

(defun wfb-object-file-name (file)
  (concatenate 'string *wfb-home* "/" file *wfb-object-file-suffix*)
  )


;;; LOAD-WFB

(defun load-wfb ()

  (dolist (filename *ALL-WFB-FILES*)
    (load-wfb-file filename))
  )


(defun compile-wfb-file (filename)
  (compile-file (wfb-source-file-name filename)
		:output-file (wfb-object-file-name filename)
		:IF-NEWER T)
  )


(defun load-wfb-source-file (filename)

  (let ((src-filename  (wfb-source-file-name filename)))
    (if (probe-file src-filename)
	(load src-filename)
      ;;else
        NIL
	))
  )

	       
(defun load-wfb-object-file (filename)

  (let ((obj-filename  (wfb-object-file-name filename)))
    (if (probe-file obj-filename)
	(load obj-filename)
      ;;else
        NIL
	))
  )

(defun load-wfb-file (filename)

  (or (load-wfb-object-file  filename)
      (load-wfb-source-file  filename)
      )
  )

