;;;; -*- Mode:Lisp; Package:WFB; Syntax:COMMON-LISP; Base:10 -*-

#-(or GCL LUCID) (in-package :WFB)
#+(or GCL LUCID) (in-package :WFB)

;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; Copyright (c) 1999 by Micheal Scott Hewett
;;;
;;; This code may be used by anyone for any project, but may not
;;; be sold in source or object form without permission.
;;; If in doubt, follow the GNU GPL2 guidelines.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; (Contact: hewett@cs.utexas.edu or hewett@cs.stanford.edu)
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

;;; ********************************************************************
;;;
;;; wfb-interface.lisp   -  Top-level interface routines for the
;;;                         three servers of the WFB.
;;;
;;; Mike Hewett    23 November 1999
;;;
;;; SERVICES-INTERFACE
;;; HTML-INTERFACE
;;; PASSTHROUGH-INTERFACE
;;; ********************************************************************



(defun basic-server-loop (connection parser-fn)

  (let ((in-line   NIL))
    (loop 
      (setq in-line (read-line (conn-input-stream connection) NIL :EOF))
      (when (eq in-line :EOF)
	(return))
      
      (apply parser-fn (list in-line (conn-input-stream connection)))
      )
    )
  )


(defun service-loop (connection)

  (basic-server-loop connection #'process-service-input)
  )

(defun html-loop (connection)

  (basic-server-loop connection #'process-html-input)
  )


(defun passthrough-loop (connection)

  (basic-server-loop connection #'process-passthrough-input)
  )

