;;; -*- Mode:Lisp; Package:USER; Syntax:COMMON-LISP; Base:10 -*-

#+(or GCL LUCID) (in-package :user)
#-(or GCL LUCID) (in-package :cl-user)

(provide 'algy)


;;; Copyright (c) 1990-94 by Benjamin J. Kuipers

;;;;----------------  Algernon v2.0  ---------------------------------
;;;
;;; algy.lisp        Setup, load, compile Algernon
;;;
;;; 20 Jun 1994   Mike Hewett
;;; 17 Oct 1996   (mh) Updated for Algernon v3.0 (AAM based)
;;;
;;;;-----------------------------------------------------------------  
;;; Modified by BJK (1-14-92) for the ES version.
;;; Modified by MH  (6-20-94) for Algernon v2
;;; Restructured by MH  (7 Feb 96) for Algernon v2

;;;==================================================================
;;; SETUP Instructions
;;;------------------------------------------------------------------
;;;
;;; This file defines the variables used to locate Algernon's source
;;; and binary files.  Actual loading is performed by "aload_aux.lisp".
;;; For each cfguration, load a file containing settings for the
;;; necessary variables:
;;;
;;;    *ROOT-DIR*                part of the path common to both source and object files.
;;;    *BIN-DIR*                 name of the subdirectory used for object files.
;;;    *LISP-FILE-EXTENSION*     typically ".lisp".
;;;    *OBJECT-FILE-EXTENSION*   equivalent of ".lisp" for compiled files.
;;;    *PATH-TERMINATOR*         the character between directories ('/' for UNIX).
;;;    *KB-INTERFACE*            determines which KB interface is used.
;;;
;;; You can create a cfguration file "cfg-X" for your configuration X, then
;;; add a line below to cause it to be loaded in combination with any
;;; *FEATURE* components you have in your environment.  You can set the
;;; appropriate features in the LISP init file.  
;;;
;;; Init file information for various LISPs:
;;;
;;;    LISP         init file automatically loaded
;;;    ----         ------------------------------
;;;    AKCL/GCL     ./init.lsp            <-- loads from current directory or
;;;                 $HOME/init.lsp        <-- home directory if none found in ".".
;;;
;;;    Allegro      $HOME/.clinit.cl
;;;
;;;    Lucid        $HOME/lisp-init.lisp
;;;
;;;    Macintosh    init.lisp             <-- Home directory of MCL (??)
;;;
;;;-----------------------------------------------------------------------


(push :ALGY3 *features*)


;;; Standard configurations for the AI group at the University of Texas.


#+(and :SUN    :ALLEGRO-V4.2)
(load "/u/qr/algy3/config/cfg-SUN-ALLEGRO-4-2.lisp")
#+(and :SUN    :ALLEGRO-V4.3)
(load "/u/qr/algy3/config/cfg-SUN-ALLEGRO-4-3.lisp")
#+(and :SUN    :ALLEGRO-V4.3.1)
(load "/u/qr/algy3/config/cfg-SUN-ALLEGRO-4-3-1.lisp")
#+(and :SUN    :LCL4.1)
(load "/u/qr/algy3/config/cfg-SUN-LUCID-4-1.lisp")
#+(and :RS6000 :ALLEGRO-V4.2)
(load "/u/qr/algy3/config/cfg-RS6K-ALLEGRO-4-2.lisp")
#+(and :ALPHA :HARLEQUIN-COMMON-LISP)
(load "/u/qr/algy3/config/cfg-ALPHA-HARLEQUIN.lisp")
#+(and :APPLE  :MCL)
(load "/u/qr/algy3/config/cfg-APPLE-MCL-3-0.lisp")
#+(and         :GCL)
(load "/u/qr/algy3/config/cfg-UNIX-GCL.lisp")


(when (not (boundp '*root-dir*))
  (break "Algernon is not configured for this LISP."))


;;; Main Algernon directory in public:
(defparameter @algy-path  *root-dir*  "Path to main Algernon directory.")



;;; Then the other paths:
(defparameter @algy-source-path
  (format nil "~asrc~A" @algy-path *PATH-TERMINATOR*) 
  "Path to source files")

(defparameter @algy-object-path
  (format nil "~abins~A~A" @algy-path *PATH-TERMINATOR* *BIN-DIR*)
  "Path to object files.")

(defparameter @algy-help-path
  (format nil "~ahelp~A" @algy-path *PATH-TERMINATOR*))

(defparameter @algy-example-path
  (format nil "~aexamples~a" @algy-path *PATH-TERMINATOR*))

(defparameter @algy-gui-path
  (format nil "~agui~a" @algy-path *PATH-TERMINATOR*))



;;; And the suffixes for various kinds of files:
(defparameter @lisp-file-extension *LISP-FILE-EXTENSION*)

(defparameter @algy-help-suffix ".txt")

(defparameter @obj-file-extension  *OBJECT-FILE-EXTENSION*)

(defparameter @kb-file-extension ".kb"
	 "The file name extension used by Algernon to store knowledge-bases.")



;;; Finally, the name of the files holding the code for the 
;;; default knowledge-bases

(defparameter @algy-kb-path
	      @algy-source-path
  "The directory in which Algernon looks for the built-in knowledge bases.")

;;; Override some strange defaults (especially under AKCL):
;;(proclaim '(optimize (safety 2) (speed 2) (space 2)))
;;(proclaim '(optimize (safety 0) (speed 3) (space 0)))

;;; One last global:
(defvar *load-times* nil "Assoc list of files and when they were loaded.")


;;; Some useful pathname construction routines


(defun algy-source-file-name (filename &OPTIONAL (path @algy-source-path))
  (concatenate 'string path filename @lisp-file-extension)
  )

(defun algy-object-file-name (filename &OPTIONAL (path @algy-object-path))
  (concatenate 'string path filename @obj-file-extension)
  )

(defun algy-example-source-file-name (filename &OPTIONAL (path @algy-example-path))
  (concatenate 'string path filename @lisp-file-extension)
  )

(defun algy-example-object-file-name (filename &OPTIONAL (path @algy-example-path))
  (concatenate 'string path filename @obj-file-extension)
  )



;; Print out changes file (if any).
#|
(setq *changes-path* (algy-source-file-name "version.lisp"))

(if (probe-file *changes-path*)
    (with-open-file (changes-file *changes-path*)
      (format t "~%")
      (loop (let ((inline (read-line changes-file nil 'eof)))
	      (if (eql inline 'eof)
		  (return)
		  (write-line inline))))
      (format t "~%")))
|#


;;; Then load the rest.

(load (algy-source-file-name "aam-load"))

;;; Load the Algernon modules
(load-or-compile-sfs)
(load-or-compile-gfp)
(load-or-compile-algy)

#+(and :SUN    (or :ALLEGRO-V4.3 :ALLEGRO-V4.3.1))
(progn
  (format t "~%Loading Amaze - Algernon's GUI.  Run (amaze) to start it.")
  (load (algy-object-file-name "amaze/amaze" @algy-gui-path))
  )

#-(and :SUN    (or :ALLEGRO-V4.3 :ALLEGRO-V4.3.1))
(progn
  (format t "~%Sorry, you can not use Amaze - Algernon's GUI - with this version of LISP.~%")
  )

(aam:trace-aam 1)
