(in-package :user)

;;; Using belief.lisp to implement Pearl's example.

(defun setup-murder-network ()

  (tell '((:taxonomy (nodes
		       A		; identity of killer
		       B		; identity of last holder of weapon
		       ; C		; report from fingerprint-testing lab
		       ))))

  (tell '((child A B)			; A -> B -> C
	  ; (child B C)
	  ))

  ;; Top-level hypothesis:  Who is the killer?

  (tell '((net-root current-context A)
	  (description A "identity of killer")
	  (values A (A1 A2 A3))))

  ;; First level of evidence:  Who last held the weapon?
  ;;
  ;;   p(B/A) = if B=A then 0.80 else 0.10.

  (tell '((description B "identity of last holder of weapon")
	  (leaf current-context B)
	  (values B (A1 A2 A3))
	  (matrix B ((0.80 0.10 0.10)
		     (0.10 0.80 0.10)
		     (0.10 0.10 0.80)))
	  ))

  ;;; Initialize the belief network by setting the lambda values
  ;;; of all leaf nodes to be vectors of ones.  This causes propagation
  ;;; of belief values across the network and so may take a long time.

  (tell '((init-bnet-leaves current-context true)))

  )

(defun murder (&key (setup nil))
  (when setup
    (acom-reset)
    (load "/u/qr/algy3/examples/belief.lisp")
    (setup-belief))
;  (reset-algy)
;  (load-kb 'belief)
  (setup-murder-network)
  )

;;; Reproduce two examples from Pearl [1986].

(defun ex-2-1 ()			; Pearl, pp.256
  (murder :setup t)
  (format t "~% Initial state. ~%")
  (tell '((:show A)))

  (format t "~% Assert priors  =>  BEL(B) = (0.60 0.30 0.10). ~%")
  (tell '((pi B (0.60 0.30 0.10))))
  (tell '((:show A)))
  (tell '((:show B)))

  (format t "~% Assert evidence  =>  BEL(B) = (0.676 0.254 0.07). ~%")
  (tell '((new-evidence B (0.80 0.60 0.50))))
  (tell '((:show A)))
  (tell '((:show B)))
  )

;;; Ex-2-1 does not compute BEL(A) because pi(A) wasn't asserted.  Is this reasonable?

(defun ex-2-2 ()			; Pearl, pp.261-2
  (murder :setup t)
  (format t "~% Initial state.")
;;  (tell '((:show A)))
;;  (tell '((:show B)))
  
  (format t "~% Assert priors  =>  pi(B) = BEL(B) = (0.66 0.17 0.17). ~%")
  (tell '((pi A (0.80 0.10 0.10))))
;;  (tell '((:show A)))
;;  (tell '((:show B)))
  
  (format t "~% Assert evidence  =>  BEL(A) = (0.84  0.085 0.076)
                      BEL(B) = (0.738 0.142 0.119). ~%")
  (tell '((new-evidence B (0.80 0.60 0.50))))
  (tell '((:show A)))
  (tell '((:show B)))
  
  (format t "~% Assert alibi  =>  BEL(A) = (0.343, 0.349, 0.308)
                   BEL(B) = (0.423 0.326 0.251). ~%")
  (let ((*trace-bayes* t))
    (tell '((new-evidence A (0.10 1.0 1.0))))
    )
  (tell '((:show A)))
  (tell '((:show B)))
  )

;;;  In [Pearl, 1986, p.262, l.12-14], he does the following computation
;;;  (typos corrected for consistency with result and previous discussion).
;;;
;;;    BEL(A)  =  alpha * lambda(A) * pi(A)
;;;            =  alpha * (0.075, 0.61, 0.54) * (0.84, 0.085, 0.076)
;;;            =  (0.404, 0.333, 0.263).
;;;
;;;  I contacted him (4-15-93), and he faxed an errata sheet correcting it to
;;;
;;;    BEL(A)  =  alpha * lambda(A) * pi(A)
;;;            =  alpha * (0.075, 0.61, 0.54) * (0.8, 0.1, 0.1)
;;;            =  (0.343, 0.349, 0.308).
;;;
;;;  With the correction, he and I get the same results for BEL(A).
;;;
;;;  Hmmm.  Even with the correction, BEL(B) looks wrong.
