(in-package :user)

;;; If the prior probability of a Rare Disease is very low, even a
;;; positive result on an Accurate Test gives less information than
;;; you might think.  This example comes from the Cancer Test example
;;; in Kassirer & Kopelman, Learning Clinical Reasoning.  Baltimore:
;;; Williams & Wilkins, 1991, figure 4.3, page 20.

(defun setup-rare-disease-network ()

  (tell '((:taxonomy (nodes
		       A		; presence of Rare Disease
		       B		; result of Accurate Test
		       ))))

  (tell '((child A B)			; A -> B
	  ))

  ;; Hypothesis:  Rare Disease or not.

  (tell '((description A "presence of Rare Disease")
	  (net-root current-context A)
	  (values A '(pos neg))))

  ;; Evidence: Accurate Test
  ;;
  ;; p(false pos) = p(false neg) = 0.05

  (tell '((description B "result from Accurate Test")
	  (leaf current-context B)
	  (values B (pos neg))
	  (matrix B ((0.95 0.05)
		     (0.05 0.95)))
	  ))

  ;; Initialize all leaves.

  (tell '((init-bnet-leaves current-context true)))

  )


(defun rare-disease (&key (setup nil))
  (when setup
    (acom-reset)
    (load "/u/qr/algy3/examples/belief.lisp")
    (setup-belief))
;  (reset-algy)
;  (load-kb 'belief)
  (setup-rare-disease-network) )

;;; This example shows the effect of a positive test on a rare disease.

(defun RD ()
  (rare-disease :setup t)
  (format t "~% Initial state. ~%")
  (tell '((:show A)))
  (tell '((:show B)))

  (format t "~% Assert priors. ~%")
  (tell '((pi A (0.005 0.995))))
  (tell '((:show A)))
  (tell '((:show B)))

  (format t "~% Assert evidence. ~%")
  (tell '((new-evidence B (1.0 0.0))))
  (tell '((:show A)))
  (tell '((:show B)))
  )

;;; This version is designed to give just the answer, given a prior probability.
;;; It is very inefficient, since it resets and reloads the KB each time.

(defun RD2 (RD-prior)
  (let ((input-vector (list RD-prior (- 1.0 RD-prior))))
    (rare-disease :setup t)
    (tell `((pi A ',input-vector)))
    (format t "~2%Given prior p(RD) = ~6,4f, "  RD-prior)
    (tell '((new-evidence B '(1.0 0.0))))
    (let* ((result (ask '((belief A ?pair)) :collect '?pair)))
      (format t "posterior p(RD / +test) = ~6,4f.~%" (caar result))
      result)))

