;;; Counter code adapted from p. 37 of "Algernon for Expert Systems"
;;; This illustrates a simple form of non-monotonic reasoning.
;;;
;;; Mike Hewett  18 Apr 1997
;;;

(in-package :cl-user)


(defun facts-about-counter ()

  (tell '((:taxonomy (Things
                      (Counters)))))

  (tell '((:slot increment     (Counters Booleans) :cardinality 1)
          (:slot current-count (Counters :number)  :cardinality 1)))

  (with-no-continuations
      (tell '((:rules Counters
		      ((increment ?ctr true)
		       (current-count ?ctr ?n)
		       (:bind ?m (+ ?n 1))
		       ->
		       (:clear-slot ?ctr current-count)
		       (current-count ?ctr ?m)
		       (:eval (format t "~%Current counter value is ~a." ?m))
		       )))))

  )


(defun queries-about-counter ()

  (tell '((:a ?c (isa ?c Counters))
	  (current-count ?c 0)

	  (:clear-slot ?c increment)
	  (increment ?c true)

	  (:clear-slot ?c increment)
	  (increment ?c true)

	  (:clear-slot ?c increment)
	  (increment ?c true)
	  ))
  )


;;; This is the original version
#|
(defun queries-about-counter ()

  (tell '((:a ?c (isa ?c Counters))
	  (current-count ?c 0)
	  (current-count ?c ?n1)
	  (:eval (format t "~%Current counter value is ~a." ?n1))

	  (increment ?c true)
	  (current-count ?c ?n2)
	  (:eval (format t "~%Current counter value is ~a." ?n2))

	  (increment ?c true)
	  (current-count ?c ?n)
	  (:eval (format t "~%Current counter value is ~a." ?n))))
  )
|#

