;;; Copyright (c) 1988, 1992, Benjamin Kuipers.

#+(or GCL LUCID) (in-package :user)
#-(or GCL LUCID) (in-package :cl-user)


;;;
;;; JOHN ALDEN STORY
;;;
;;;
(defun john-background-ontology ()

  ;; This example uses the taxonomy in the background knowledge-base, plus
  ;; the new set "time-units" and its element "years".
  ;;
  (tell '((:taxonomy (objects
		      (contexts *context*)
		      (physical-objects
		       (people))
		      (physical-attributes
		       (genders male female))
		      (time-units years))))
	:comment "Extension to taxonomy.")

  ;; This was not in the original John.  Where does it go?
  (tell '((:slot current (contexts contexts))))

  ;; "Age" is a three place relation between a physical object, its
  ;; age (which is not typed (i.e. is typed to nil) since it will just
  ;; be a number), and the time-unit the age is measured in.
  ;;
  (tell '((:slot age (physical-objects :number time-units) :cardinality 1))
	:comment "Age.")
    
  (tell '((:slot spouse (people people)  :cardinality 1
	         :comment "(spouse a b) = The spouse of a is b.")
	  ;;
	  (:slot wife (people people)    :cardinality 1
	         :comment "(wife a b) = The wife of a is b.")
	  ;;
	  (:slot husband (people people) :cardinality 1
	         :comment "(husband a b) = The husband of a is b.")
	  ;;
	  (:slot friend (people people)
	         :comment "(friend a b) = A friend of a is b.")

	  (:slot gender (people genders)
	         :comment "(gender a b) = The gender of a is b.")

	  (:slot speaker (contexts people)
	         :comment "(speaker c p) = The speaker in context c is p.")

	  (:slot recent (contexts objects)
	         :comment "(recent c o) = o was recently the focus of context c.")
	  )
	:comment "People.")

  ;; Husband and wife imply genders:
	      
  (tell '((:rules people
	   ((wife ?x ?p1) -> (gender ?p1 female))
	   ((husband ?x ?p1) -> (gender ?p1 male))
	   ((wife ?a ?b) -> (spouse ?a ?b) (husband ?b ?a))
	   ((husband ?a ?b) -> (spouse ?a ?b) (wife ?b ?a))
	   ))
	:comment "Rules")
  )

;;; JOHN ALDEN STORY
;;;
;;; Illustrates the use of Algernon to express definite descriptions
;;; and represent a simple narrative.  Part of the aim here is for the
;;; Algernon predicates to be, as nearly as possible, syntactic
;;; variants of the english.

(defun facts-about-john ()
  (acom-reset)
  
  (john-background-ontology)
  (with-normal-output
  
  ;; First the title of the story to establish a new context.
  ;; The context is used principally to resolve the pronouns in
  ;; the narrative.
  ;;
  (tell '((:forc (?ja-story Contexts) (name ?ja-story "JA-story"))
	  (:clear-slot *context* current)
	  (current *context* ?ja-story))
	:comment "The John Alden Story.")
  
  ;; We use the "speaker" slot in the current context to hold the
  ;; speaker in the story.  We then treat "my" or "I" as a definite
  ;; description, creating the speaker if none is known.
  ;;
  (tell '((:the (?me People)
	    (current *context* ?cc)
	    (speaker ?cc       ?me))
	  (name ?me "John Alden"))
	:comment "My name is John Alden.")
  
  (tell '((:the (?me People)
	    (current *context* ?cc)
	    (speaker ?cc       ?me))
	  (age ?me 25 years))
	:comment "I am 25 years old.")
  
  ;; When another frame is mentioned we put it in the "recent" slot of
  ;; the current context so we can retrieve it with third person
  ;; pronouns later.
  ;;
  (tell '((:the (?me People)
	    (current *context* ?cc)
	    (speaker ?cc       ?me))
	  (:the (?w People) (wife ?me ?w))
	  (age ?w 23 years)
	  (current *context* ?cc)
	  (recent  ?cc       ?w))
	:comment "My wife is 23 years old.")
					; => add to (unordered) context
  
  ;; "Her" or "she" is a definite description retrieving
  ;; a recently mentioned female.
  ;;
  (tell '((:the (?her People)
	   (current *context* ?cc)
	   (recent  ?cc       ?her)
	   (gender ?her female))
	  (name ?her "Priscilla"))
	:comment "Her name is Priscilla.")
  
  ;; An indefinite description (e.g. "a friend") can be represented
  ;; using ":forc" (find or create), or using ":a" (create new).
  ;;
  (tell '((:the (?her People)
	   (current *context* ?cc)
	   (recent  ?cc       ?her)
	   (gender ?her female))

	  (:forc (?ms People)
	   (friend ?her ?ms)
	   (name ?ms "Miles Standish") 	; Algernon doesn't know
	   (gender ?ms male))		        ; Miles is a man's name.

	   (current *context* ?cc)
	   (recent  ?cc       ?ms))
	:comment "She has a friend named Miles Standish.")
 
  (tell '((:the (?him People)
	    (current *context* ?cc)
	    (recent  ?cc       ?him)
	    (gender ?him male))
	  (age ?him 40 years))
	:comment "He is 40 years old.")
 
  (tell '((:forc (?cm People)
		 (name ?p "Priscilla")
		 (friend ?p ?cm)
		 (name ?cm "Cotton Mather")
		 (gender ?cm male))

	   (current *context* ?cc)
	   (recent  ?cc       ?cm))
	:comment "Priscilla also has a friend named Cotton Mather.")
  ))

;;; JOHN ALDEN STORY QUERIES
;;;
(defun queries-about-john ()
  
  ;; First we return attention to the John Alden story:
  ;;
  (tell '((:clear-slot *context* current)
	  (current *context* ja-story))
	:comment "In the John Alden story ...")

  (ask '((:the (?me People)
	   (current *context* ?cc)
	   (speaker ?cc ?me))

	 (:the (?w People) (wife ?me ?w))
	 (age ?w ?a ?units)
	 (name ?w ?n))
       :comment  "How old is my wife?"
       :collect '(?n is ?a ?units old))
  
  (ask '((name    ?p  "Priscilla")
	 (husband ?p  ?h)
	 (:show ?h)
	 (name ?h ?n))
       :comment "Who is Priscilla's husband?"
       :collect '?n)
  
  (ask '((name   ?p "Priscilla")
	 (friend ?p ?friend)
	 (name ?friend ?name))
       :comment "What is Priscilla's friend's name ?"
       :collect '?name)

  t)

;;;   - add demonstration of ":a" in addition to ":forc".
