;;; -*- Syntax: Common-lisp; Package: USER -*-

; Bank Problem

;This is puzzle 1 in "101 Puzzles in Thought and Logic" by C.R. Wylie Jr:
;
;  In a certain bank the positions of cashier, manager, and teller
;  are held by Brown, Jones and Smith, though not necessarily respectively.
;    The teller, who was an only child, earns the least.
;    Smith, who married Brown's sister, earns more than the manager.
;  What position does each man fill ?
;
;My solution in english is as follows:
;  1. Smith earns more than the manager and hence Smith is not the manager.
;  2. Smith earns more than the manager and hence Smith is not the teller
;  (who earns the least).
;  3. Hence Smith is the cashier.
;  4. The teller is an only child hence Brown is not the teller.
;  5. Hence Brown is the manager (since we already know that Smith is the cashier).

; To represent the problem in Algy we first need to define terms:
(defun facts-about-bank ()
  (let ((*contra-positive* t))
    (a-assert "New slots."
              '((:slot sister (people people)
                       :comment "(sister a b) = The sister of a is b.")
                (:slot only-child (people booleans)
                       :cardinality 1
                       :comment "(only-child a true) = a is an only child.")))
    
    (a-assert "Sisters and only children."
              '((:RULES people
                        ((sister ?p1 ?p2) -> (not (only-child ?p1 true))))))
    
    (a-assert "In a certain bank the positions of cashier, manager, and teller
	    are held by Brown, Jones and Smith, though not necessarily respectively."
              '(; the set of positions:
                (:a ?c (name c "cashier"))
		(:a ?t (name ?t "teller"))
		(:a ?m (name ?m "manager"))
                (:a ?pos (name ?pos "positions"))
		(member ?pos ?c) (member ?pos ?m) (member ?pos ?t)
                ;
                ; the employees:
                (:a ?b (name ?b "Brown"))
		(:a ?j (name ?j "Jones"))
		(:a ?s (name ?s "Smith"))
		
                (:a ?e (name ?e "employees"))
		(imp-superset employees people)
                (member ?e ?b) (member ?e ?j) (member ?e ?s)
                
                (:rules ?e
                        ;; First existance -- Every employee holds a job:
                        ((coreferent ?e1 ?c)
                         <- (not (coreferent ?e1 ?t)) (not (coreferent ?e1 ?m)))
                        
                        ;; Then uniqueness -- one employee per position and vice versa:
                        ((coreferent ?e1 ?p1) (member ?pos ?p1)
                         ->
                         (member ?e ?e2) (:neq ?e1 ?e2)
                         (not (coreferent ?e2 ?p1)))
                        ((coreferent ?e1 ?p1) (member ?pos ?p1)
                         ->
                         (member ?pos ?p2) (:neq ?p1 ?p2)
                         (not (coreferent ?e1 ?p2))))))
    
    ;; Hack -- Here I use "least" when I really should use "earns-least".
    (a-assert "The teller, who was an only child, earns the least."
              '((only-child teller true) (least teller positions)))
    
    (a-assert "Smith, who married Brown's sister, earns more than the manager."
              '((:forc ?sis (sister Brown ?sis))
                (spouse Smith ?sis)
                (greater Smith manager)))))

(defun queries-about-bank ()
  (let ((*contra-positive* t))
    (a-query "What positions do Brown, Smith and Jones hold ?"
             ;;; Note that we read this as "Brown, Smith and Jones are coreferent with
             ;;; which employees ?".
             '((coreferent Brown ?be) (isa ?be positions)
               (coreferent Smith ?se) (isa ?se positions)
               (coreferent Jones ?je) (isa ?je positions)))
    (a-query "If Smith were the manager then how could he earn more than the manager ?"
             '((:assume (coreferent Smith manager))
               (not (greater Smith manager))))
    (a-query "If Smith were the teller then how could he earn more than the manager?"
             '((:assume (coreferent Smith teller))
               (not (greater Smith manager))))
    (a-query "Hence, Smith holds which job ?"
             '((coreferent Smith ?se) (isa ?se positions)))
    (a-query "If Brown were the teller then would he be an only child ?"
             '((:assume (coreferent Brown teller))
               (only-child Brown true)))
    (a-query "Hence Brown holds which job ?"
             '((coreferent Brown ?be) (isa ?be positions)))
    (a-query "Hence Jones holds which job ?"
             '((coreferent Jones ?je) (isa ?je positions)))))
