
(defun build-frames (n)
  (a-assert "Link slot" '((:slot link (objects objects))
                          (:slot first-frame (contexts objects))))
  (let (current-frame
        last-frame)
    (dotimes (x n)
      (setq current-frame (format nil "BF~a" x))
      (a-assert nil `((:a ?x (name ?x ,current-frame))))
      (if last-frame
        (a-assert nil `((link ,last-frame ,(intern current-frame))))
        (a-assert nil `((first-frame global-context ,(intern current-frame)))))
      (setq last-frame current-frame))))

(defun bf (n)
  (a-assert "Link slot" '((:slot link (objects objects))
                          (:slot first-frame (contexts objects))))
  (let (last-frame)
    (flet ((my-setq (x) (setq last-frame x)))
      (dotimes (x n)
        (if last-frame
          (a-assert nil `((:a ?x
			      (link (:quote ,last-frame) ?x)
			      (:apply ,#'my-setq (?x)))))
          (a-assert nil `((:a ?x
			      (first-frame global-context ?x)
			      (:apply ,#'my-setq (?x))))))))))
