
(in-package :CL-USER)


(defun foo ()
  (a-assert "Slots"
	    '((:slot s1 (objects objects))
	      (:slot s2 (objects objects))
	      (:slot s3 (objects objects))))
  (a-assert "Frames"
	    '((:a ?x (name ?x "X") (isa ?x objects))
	      (:a ?y (name ?y "Y") (isa ?y objects))
	      (:a ?z (name ?z "Z") (isa ?z objects))
	      (:a ?z2 (name ?z2 "Z2") (isa ?z2 objects))))
  (a-assert "Rule"
	    '((:rules objects
		      ((s1 ?x ?y)
		       (s2 ?y ?z)
		       (:eval (format t
				      "~%Branching on ~a ~a ~a." '?x '?y '?z))
		       ->
		       (s3 ?x ?z)))))
  (a-assert "Facts"
	    '((s1 x y) (s2 y z) (s2 y z2))))



;; Same as above, but uses TELL so that the trace level is preserved.

(defun foo2 ()

  (tell '((:slot s1 (objects objects))
	  (:slot s2 (objects objects))
	  (:slot s3 (objects objects)))
	:comment "Slots")

  (tell '((:a ?x (name ?x "X") (isa ?x objects))
	  (:a ?y (name ?y "Y") (isa ?y objects))
	  (:a ?z (name ?z "Z") (isa ?z objects))
	  (:a ?z2 (name ?z2 "Z2") (isa ?z2 objects)))
	:comment "Frames"
	)

  (tell '((:rules objects
		  ((s1 ?x ?y)
		   (s2 ?y ?z)
		   (:eval (format t
				  "~%Branching on ~a ~a ~a." '?x '?y '?z))
		   ->
		   (s3 ?x ?z))))
	:comment "Rule"
	)

  (tell '((s1 x y) (s2 y z) (s2 y z2))
	:comment "Facts"))
