
;;; Example from formalism of negation:
;;;
;;; 1. If Mary waters the flowers and the flowers bloom then Mary is happy.
;;; 2. If Mary does not water the flowers then they do not bloom.
;;; 3. Mary is not happy.


;;; We can express this situation using the knowledge-base:
;;; 
;;;   C  = {Mary, Flowers}
;;;   R  = {waters, blooms, happy}
;;;   Nr = { happy(Mary,true) <- waters(Mary,Flowers), blooms(Flowers,true),
;;;          (NOT blooms(Flowers,true)) <- (NOT waters(Mary,Flowers))
;;;   Ar = {}
;;;   F    = {(NOT happy(Mary))}
;;;   P    = C x R
;;;
;;; Note that logically this knowledge-base implies (NOT blooms(Flowers)).
;;;
;;; (for rest of formal version see negation paper).

(defun facts-about-flowers ()
    (tell '((:taxonomy (objects (plants))))
	      :comment "Taxonomy")
    (tell '((:slot happy (people booleans)
		       :comment "(happy p true) = p is happy.")
		(:slot waters (people plants)
		       :comment "(waters p plant) = p waters plant.")
		(:slot blooms (plants booleans)
		       :comment "(blooms plant true) = plant blooms."))
	      :comment "Slots")
    (tell '((:a ?m
		    (name ?m "Mary")
		    (isa ?m people))
		(:a ?f
		    (name ?f "Marys-Flowers")
		    (isa ?f plants))
		(:rules people
			((happy ?m true) <- (waters ?m ?f) (blooms ?f true)))
		(:rules plants
			((not (blooms ?f true)) <- (not (waters ?m ?f))))
		(not (happy ?m true)))
	      :comment "Mary"))

(defun queries-about-flowers ()
  (ask '((not (blooms Marys-Flowers true)))
           :comment "Do the flowers bloom ?")
  (ask '((:assume (blooms Marys-Flowers true))
             (:assume (waters Mary Marys-Flowers))
             (happy Mary true))
           :comment "Proof by contradiction.")
  (ask '((not (blooms Marys-Flowers true)))
           :comment "Do the flowers bloom ?"))

;;; But its easier with contra-positives:

(defun facts-about-flowers2 ()
  (let ((*contra-positive* t))
    (tell '((:taxonomy (objects (plants))))
	      :comment "Taxonomy")
    (tell '((:slot happy (people booleans)
		       :comment "(happy p true) = p is happy.")
		(:slot waters (people plants)
		       :comment "(waters p plant) = p waters plant.")
		(:slot blooms (plants booleans)
		       :comment "(blooms plant true) = plant blooms."))
	      :comment "Slots")
    (tell '((:a ?m
		    (name ?m "Mary")
		    (isa ?m people))
		(:a ?f
		    (name ?f "Marys-Flowers")
		    (isa ?f plants))
		(:rules people
			((happy ?m true) <- (waters ?m ?f) (blooms ?f true)))
		(:rules plants
			((not (blooms ?f true)) <- (not (waters ?m ?f))))
		(not (happy ?m true)))
	      :comment "Mary")))

(defun queries-about-flowers2 ()
  (let ((*contra-positive* t))
    (ask '((not (blooms Marys-Flowers true)))
	     :comment "Do the flowers not bloom ?")
    (ask '((:assume (blooms Marys-Flowers true)))
	      :comment "Assume they do.")
    (ask '((happy Mary true))
	      :comment "Query negation of fact from problem.")
    (ask '((not (blooms Marys-Flowers true)))
	     :comment "Do the flowers not bloom ?")))
