(in-package :CL-USER)

;;; Nixon

(defun facts-about-nixon ()
  (facts-about-views)
  (a-assert "Taxonomy"
            '((:taxonomy (people (republicans)
				 (quakers (pacifist-quakers)
					  (non-pacifist-quakers))))))
  (a-assert "Slots"
            '((:slot pacifist (people booleans)
                     :cardinality 1
                     :comment "(pacifist p true) = p is a pacifist.")))
  (a-assert "Simple view of quakers."
            '((:a ?v (name ?v "SIMPLE-QUAKER-VIEW"))
              (simple-view quakers ?v)
              (:a ?s (name ?s "SIMPLE-QUAKERS"))
              (rule-set ?v ?s)
              (:rules ?s
                      ;; In the simple view quakers are pacifists:
                      ((pacifist ?x true) <-))))
  (a-assert "Simple view of republicans."
            '((:a ?v (name ?v "SIMPLE-REPUBLICAN-VIEW"))
              (simple-view republicans ?v)
              (:a ?s (name ?s "SIMPLE-REPUBLICANS"))
              (rule-set ?v ?s)
              (:rules ?s
                      ;; In the simple view republicans are not pacifists:
                      ((not (pacifist ?x true)) <-))))
  (a-assert "Complex view of quakers."
            '((:a ?v2 (name ?v2 "COMPLEX-QUAKER-VIEW"))
              (view quakers ?v2)
              (more-detailed-view simple-quaker-view ?v2)
              (:a ?s (name ?s "COMPLEX-QUAKERS"))
              (rule-set ?v2 ?s)
              ;; There are actually two kinds of quakers:
              (:w-contra-positive 
               (:rules ?s
                       ((isa ?x pacifist-quakers) <- (not (isa ?x non-pacifist-quakers)))))
              (:rules ?s
                      ;; By default assume pacifist-quakers:
                      ((isa ?x ?s) -> (:assume (isa ?x pacifist-quakers))))))
  ;; pacifist-quakers are pacifists, but we say nothing about non-pacifist-quakers:
  (a-assert "pacifist-quakers"
            '((:rules pacifist-quakers
                      ((pacifist ?x true) <-))))

  (a-assert "Nixon"
            '((:a ?n (name ?n "NIXON"))
              (isa ?n republicans)
              (isa ?n quakers))))

(defun queries-about-nixon ()
  ;; Set tracing so we can see the resolution of assumption conflicts:
  ;(setq *trace-contradiction-resolvers* t)
;;  (trace-contra)
  (a-query "What views do we take of Nixon ?"
           '((take-view Nixon ?v)))
  (a-query "Is Nixon a pacifist ?"
           '((pacifist Nixon true)))
  (a-query "Is Nixon not a pacifist ?"
           '((not (pacifist Nixon true))))
  (a-query "What views do we take of Nixon ?"
           '((take-view Nixon ?v)))
  (a-query "Is Nixon a pacifist ?"
           '((pacifist Nixon true)))
  (a-query "Is Nixon not a pacifist ?"
           '((not (pacifist Nixon true))))
  (a-query "What views do we take of Nixon ?"
           '((take-view Nixon ?v))))


;;; Views

(defun facts-about-views ()
  (a-assert "Taxonomy"
            '((:taxonomy (objects (views)))))
  (a-assert "Slots"
            '((:slot view (sets views)
                     :comment "(view s v) = A view of elements of s is v.")
              (:slot simple-view (sets views)
                     :cardinality 1
                     :comment "(simple-view s v) = The simple view of elements of s is v.")
              (:slot more-detailed-view (views views)
                     :cardinality 1
                     :comment "(more-detailed-view v1 v2) = A more detailed view than v1 is v2.")
              (:slot take-view (things views)
                     :cardinality 1
                     :comment "(take-view x v) = Take view v of x.")
              (:slot rule-set (views sets)
                     :cardinality 1
                     :comment
                     "(rule-set v s) = The rules for view v are associated with set s.")))
  (a-assert "Rules"
            '((:rules things
                      ;; Take the simple view by default:
                      ((isa ?x ?set)
                       ->
                       (simple-view ?set ?view) (:assume (take-view ?x ?view)))
                      ;; When a view fails take a more complex one:
                      ((not (take-view ?x ?v))
                       ->
                       (more-detailed-view ?v ?v2) (:assume (take-view ?x ?v2)))
                      ;; If you take a view then you get its rules:
                      ((take-view ?x ?view)
                       ->
                       (rule-set ?view ?s)
                       (isa ?x ?s)))
              (:rules views
                      ((simple-view ?s ?v) -> (view ?s ?v))))))

;;; A contradiction resolver that works on cases where the contradiction is
;;; the result of view assumptions, and attempts to resolve them.
;;; The algorythm here is very simple -- no attempt is made to select between
;;; several views which could be more complex, we just take the first we come to ...
;;;
(defun view-changer (pred assump-ll not-assump-ll conjunct)
  (declare (ignore pred) (ignore assump-ll) (ignore not-assump-ll))
  (let (bad-assumps)
    (dolist (assumps conjunct)
      ;; Look for a view assumption where a more detailed view exists and drop it:
      (if (eql (length assumps) 1)
        (push (car assumps) bad-assumps)
        (let ((bad-assump))
          (dolist (assump assumps)
            (when (and (eql (slot assump) 'take-view)
                       (silently (a-query nil `((more-detailed-view ,(value assump) ?v)))))
              (setq bad-assump assump)
              (return)))
          (if bad-assump
            (push bad-assump bad-assumps)
            (progn
              (setq bad-assumps nil)
              (return))))))
    (trace-contradiction-resolution 'view-changer bad-assumps)
    bad-assumps))

;;(pushnew (symbol-function 'view-changer) *contradiction-resolvers*)
                                  
