; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-

;;; PMES.LISP
;;; Copyright (c) 1990 by Coy Clifton Day, Jr.
;;; Portfolio Management ES Knowledge Base


;;; Uses BELIEF.LISP implementation of tree-structured subset of
;;; Judea Pearl's belief networks.  Nodes are structured
;;; according to dependency in the taxonomy.

;;; Architecture:
;;; Each variable is represented by an object called a "node".
;;; Its parent is given by (parent node ?p) and its children
;;; by (child node ?c).


;;; Stock Market Domain Tree

(defun pmes-tree ()
  (a-assert "Taxonomy"
    '((:taxonomy
	(nodes
	  decision
	    market-type
	    creativity age-of-company new-product
	    appreciation shares-outstanding
	                 institution-preference inst-number inst-percent
	    earning-ability increasing-earnings net-income
	    liquidity long-term-debt
	    stability range
	    current-price percent-change
	    profitability profit-margin
	    potential highest-price
	    undervaluation price-earnings-ratio))))

  (a-assert "belief tree"
    '((child decision market-type)
      (child decision creativity)
        (child creativity age-of-company)
	(child creativity new-product)
      (child decision appreciation)
        (child appreciation shares-outstanding)
	(child appreciation institution-preference)
          (child institution-preference inst-number)
	  (child institution-preference inst-percent)
      (child decision earning-ability)
        (child earning-ability increasing-earnings)
        (child earning-ability net-income)
      (child decision liquidity)
        (child liquidity long-term-debt)
      (child decision stability)
        (child stability range)
      (child decision current-price)
        (child current-price percent-change)
      (child decision profitability)
        (child profitability profit-margin)
      (child decision potential)
        (child potential highest-price)
      (child decision undervaluation)
        (child undervaluation price-earnings-ratio))))


(defun pmes-init ()
  (a-assert "Initializing stock market knowledge base"
    '(

;; top-level hyothesis, DECISION

  (root current-context decision)
  (description decision (:quote "ultimate \"buy\" or \"don't buy\" response"))
  (values decision (:quote ("don't buy the stock" "buy the stock")))


;; market analysis

;;   p(market-type|decision) = '((0.6 0.4)
;;                               (0.2 0.8))
  (leaf current-context market-type)
  (description market-type (:quote "general market trend (sell/buy)"))
  (values market-type (:quote ("a bear market" "a bull market")))
  (matrix market-type (:quote ((0.6 0.4)
			       (0.2 0.8))))


;; creativity

;;   p(creativity|decision) = '((c1|d1 c2|d1)
;;                              (c1|d2 c2|d2))
  (description creativity (:quote "creativity of the company"))
  (values creativity (:quote ("company not creative" "company is creative")))
  (matrix creativity (:quote ((0.7 0.3)
                              (0.4 0.6))))

;;   p(age-of-company|creativity) = '((a1|c1 a2|c1)
;;                                    (a1|c2 a2|c2))
  (leaf current-context age-of-company)
  (description age-of-company (:quote "age of the company"))
  (values age-of-company (:quote ("age <= 88 years"
				 "age > 88 years")))
  (matrix age-of-company (:quote ((0.4 0.6)
                                  (0.9 0.1))))

;;   p(new-product|creativity)
  (leaf current-context new-product)
  (description new-product (:quote "has a new product been introduced?"))
  (values new-product (:quote ("no new product" "a new product")))
  (matrix new-product (:quote ((0.8 0.2)
                               (0.3 0.7))))
;; HOW RECENTLY?


;; 1. appreciation ability

;;   p(appreciation|decision)
  (description appreciation (:quote "ability to have a large price gain"))
  (values appreciation (:quote ("low appreciation ability"
				"good appreciation ability")))
  (matrix appreciation (:quote ((0.6 0.4)
                                (0.3 0.7))))

;;   p(shares-outstanding|appreciation)
  (leaf current-context shares-outstanding)
  (description shares-outstanding (:quote "number of shares outstanding"))
  (values shares-outstanding (:quote ("no. of shares <= 30,000,000"
				      "no. of shares > 30,000,000")))
  (matrix shares-outstanding (:quote ((0.4 0.6)
                                      (0.6 0.4))))

;;   p(institution-preference|appreciation)
  (description institution-preference
	       (:quote "Is the stock preferred by financial institutions?"))
  (values institution-preference (:quote ("little institution preference"
					  "great institution preference")))
  (matrix institution-preference (:quote ((0.6 0.4)
					  (0.2 0.8))))

;;   p(inst-number|institution-preference)
  (leaf current-context inst-number)
  (description inst-number (:quote "number of institutions holding the stock"))
  (values inst-number (:quote ("number of institutions < 50"
			       "number of institutions >= 50")))
  (matrix inst-number (:quote ((0.7 0.3)
                               (0.3 0.7))))

;;   p(inst-percent|institution-preference)
  (leaf current-context inst-percent)
  (description inst-percent
	  (:quote "percentage of stocks owned by financial institutions"))
  (values inst-percent (:quote ("institution holding < 20%"
				"institution holding >= 20%")))
  (matrix inst-percent (:quote ((0.5 0.5)
                                (0.3 0.7))))


;; 2. Earning-ability

;;   p(earning-ability|decision)
  (description earning-ability (:quote "company's ability to earn money"))
  (values earning-ability (:quote ("poor earning ability"
				   "good earning ability")))
  (matrix earning-ability (:quote ((0.6 0.4)
                                   (0.2 0.8))))

;;   p(increasing-earnings|earning-ability)
  (leaf current-context increasing-earnings)
  (description increasing-earnings
	(:quote "Has there been an increase in earnings in past 2 years?"))
  (values increasing-earnings
	  (:quote ("no increase in earnings"
		   "an increase in earnings")))
  (matrix increasing-earnings (:quote ((0.8 0.2)
                                       (0.1 0.9))))

;;   p(net-income|earning-ability)
  (leaf current-context net-income)
  (description net-income (:quote "Is the net income positive?"))
  (values net-income (:quote ("net income < 0" "net income >=0")))
  (matrix net-income (:quote ((0.7 0.3)
                              (0.1 0.9))))


;; Liquidity

;;   p(liquidity|decision)
  (description liquidity (:quote "liquidity of the company"))
  (values liquidity (:quote ("poor liquidity" "good liquidity")))
  (matrix liquidity (:quote ((0.7 0.3)
                             (0.3 0.7))))

;;   p(long-term-debt|liquidity)
  (leaf current-context long-term-debt)
  (description long-term-debt (:quote "long-term debt of the company"))
  (values long-term-debt (:quote ("long-term debt <= 40%"
				  "long-term debt > 40%")))
  (matrix long-term-debt (:quote ((0.4 0.6)
                                  (0.7 0.3))))
;; PERCENT OF WHAT?


;; 4. Stability

;;   p(stability|decision)
  (description stability (:quote "stability of the stock's price"))
  (values stability (:quote ("poor stability" "fair stability"
			     "good stability")))
  (matrix stability (:quote ((0.4 0.3 0.3)
                             (0.3 0.3 0.4))))

;;   p(range|stability)
  (leaf current-context range)
  (description range (:quote "range of stock's price over past year"))
  (values range (:quote ("range <= 10" "10 < range <= 20" "range > 20")))
  (matrix range (:quote ((0.1 0.3 0.6)
                         (0.25 0.5 0.25)
                         (0.7 0.3 0.0))))


;; current price

;;   p(current-price|decision)
  (description current-price (:quote "current price compared to past price"))
  (values current-price (:quote ("low price" "medium price"
				     "high price")))
  (matrix current-price (:quote ((0.1 0.3 0.6)
                                 (0.5 0.3 0.2))))

;; p(percent-change|current-price)
  (leaf current-context percent-change)
  (description percent-change
       (:quote "percent change in the price since highest price in two years"))
  (values percent-change (:quote ("percent change < 0" "0.0 <= percent change < 0.4"
				  "percent change >= 0.4")))
  (matrix percent-change (:quote ((0.6 0.3 0.1)
				  (0.2 0.6 0.2)
				  (0.1 0.3 0.6))))


;; profitability

;; p(profitability|decision)
  (description profitability (:quote ("profitability of the company")))
  (values profitability (:quote ("poor profitability" "fair profitability"
				 "good profitability")))
  (matrix profitability (:quote ((0.5 0.4 0.1)
                                 (0.05 0.35 0.6))))

;;   p(profit-margin|profitability)
  (leaf current-context profit-margin)
  (description profit-margin
     (:quote "percent of gross revenues remaining after operating expenses"))
  (values profit-margin (:quote ("PM <= 3%" "3% < PM <= 10%" "PM > 10%")))
  (matrix profit-margin (:quote ((0.4 0.4 0.2)
				 (0.2 0.4 0.4)
				 (0.0 0.3 0.7))))


;; potential

;;   p(potential|decision)
  (description potential (:quote "potential of the stock price to increase"))
  (values potential (:quote ("low potential" "medium potential"
			     "high potential")))
  (matrix potential (:quote ((0.5 0.3 0.2)
                             (0.2 0.3 0.5))))

;;   p(highest-price|potential)
  (leaf current-context highest-price)
  (description highest-price (:quote "highest price of stock within 2 years"))
  (values highest-price (:quote ("highest price <= 50"
				 "50 < highest price <= 100"
				 "highest price > 100")))
  (matrix highest-price (:quote ((0.9 0.1 0.0)
				 (0.5 0.3 0.2)
				 (0.3 0.4 0.3))))


;; undervaluation

;;   p(undervaluation|decision)
  (description undervaluation (:quote "Is the stock a bargain?"))
  (values undervaluation (:quote ("poor undervaluation"
				  "fair undervaluation"
				  "good undervaluation")))
  (matrix undervaluation (:quote ((0.5 0.4 .1)
                                  (0.1 0.4 0.5))))

;;   p(price-earnings-ratio|undervaluation)
  (leaf current-context price-earnings-ratio)
  (description price-earnings-ratio (:quote "price/earnings ratio"))
  (values price-earnings-ratio (:quote ("PE <= 2" "2 < PE <= 6" "PE > 6")))
  (matrix price-earnings-ratio (:quote ((0.0 0.2 0.8)
					(0.2 0.5 0.3)
					(0.4 0.4 0.2))))


;; Initialize prior odds of final decision.
  (pi decision (:quote (0.5 0.5)))

                                                          )))