(in-package :user)

;;; Define the predicate:  (setof S1 (:lambda x path) S2).
;;;   Given p(x) defined by path, create S2 = { x in S1 | p(x) }.

(defun facts-about-setof ()
  (tell '((:taxonomy (sets
		      (described-sets)))))
  
  (tell '((:slot setof (sets nil described-sets)
	   :comment "(setof s1 (:lambda ?x path) s2) <-> s2 = {?x in s1 | path}")
	  (:slot description (sets nil)
	   :comment "(description s1 (:lambda ?x path)) <-> s1 = {?x in (domain s1) | path}")
	  (:slot domain (described-sets sets)
	   :backlink subset
	   :comment "(domain s1 s2) <-> s1 = {?x in s2 | (description s1)}")
	  (:slot cardinality (sets nil))))
  
  (tell '((:rules sets
	   ((setof ?s1 ?desc ?s2) -> (domain ?s2 ?s1) (description ?s2 ?desc))

	   ((cardinality ?s ?n)
	    <-
	    (:all-paths ((member ?s ?x)) nil)
	    (:bind ?list (:values ?s member))
	    (:or ((:unboundp ?n) (:bind ?n (length '?list)))
		 ((:test (numberp '?n)) (:test (= '?n (length '?list)))))))
	  
	  (:rules described-sets
	   ((description ?s ?desc)
	    (domain ?s ?dom)
	    ->
	    (:forc ?ss (selfset ?s ?ss)
		   ;; Also add isa link to hack partition problem:
		   (isa ?s ?ss))
	    (:rules ?ss (:lisp (build-setof-rule '?s '?dom '?desc))))))))

;;; Called by :lisp in :rules, this must evaluate to a list of rules.

(defun build-setof-rule (set domain description)
  (let ((free-var (second description))
        (path (third description)))
    (cond ((input-var? (frame (car path)))
           (list (preprocess `((member ',set ,free-var)
			       <-
			       (member ',domain ,free-var)
			       ,@path))))
          (t
           (list (preprocess `((member ',set ,free-var)
			       <-
			       ,@path
			       (isa ,free-var ',domain))))))))
           

(defun test-setof ()
  (tell '((:slot parent (people people))
	  (:slot child (people people))
	  (inverse parent child)
	  (:slot likes (objects objects))))

  ;; "For this example link the set people to all people."
  (tell '((:rules people
	   ((isa ?x people) -> (member people ?x)))))

  (tell '((:a ?tom (name ?tom "Tom"))
	  (:a ?lisa (name ?lisa "Lisa"))
	  (:a ?fred (name ?fred "Fred"))
	  (:a ?betty (name ?betty "Betty"))
	  
	  (child ?tom ?lisa)
	  (child ?tom ?fred)
	  (child ?tom ?betty)

	  (:a ?c (name ?c "CHOCOLATE"))
	  (likes ?lisa ?c)
	  (likes ?fred ?c)))

  (ask '((child tom ?x)
	 (likes ?x chocolate))
       :comment "Which of Tom's children like chocolate ?")

  ;; Check first form for lambda expression:  var in frame position.

  (ask '((:forc ?s (setof people (:lambda ?x ((likes ?x chocolate))) ?s))
	 (cardinality ?s ?n))
       :comment "How many people like chocolate ?")

  (ask '((:forc ?s (setof people
		    (:lambda ?x ((child tom ?x) (likes ?x chocolate))) ?s))
	 (cardinality ?s 2))
       :comment "Do two of Tom's children like chocolate ?")

  ;; Check second form for lambda expression:  var not in frame position.

  (ask '((:forc ?s (setof people (:lambda ?x ((child Tom ?x))) ?s))
	 (cardinality ?s ?n))
       :comment "How many children does Tom have?")

  (ask '((:show people)
	 (setof people ?desc ?s)
	 (:show ?s))
       :comment "Some interesting frames:"))

;;; Concerns:
;;;  - rule is stored with explicit lisp function still in it.
;;;  - set is created, but members not found until requested.


;;; Examples motivated by Chinatsu Aone's dissertation.

(defun test-setof2 ()
  (with-normal-output
  
  (tell '((:taxonomy (objects
		      (nodes n1 n2 n3 n4 n5 n6 n7 n8 n9 n10)))))
  
  (tell '((:slot connection (nodes nodes))))
  
  (tell '((connection n1 n2)
	  (connection n1 n3)
	  (connection n1 n4)
	  (connection n2 n5)
	  (connection n2 n6)
	  (connection n3 n7)
	  (connection n3 n8)
	  (connection n4 n9)
	  (connection n4 n10)))

  (ask '((:forc ?set1
	  (setof nodes
	   (:lambda ?x ((:forc ?set2
			       (setof nodes
				      (:lambda ?y ((connection ?x ?y)))
				      ?set2))
			(cardinality ?set2 2)))
	   ?set1))
	 (cardinality ?set1 ?n))
       :comment "How many nodes are connected to two other nodes ?")

  (ask '((:forc ?set1
	  (setof nodes
	   (:lambda ?x ((:forc ?set2
			       (setof nodes
				      (:lambda ?y ((connection ?x ?z)
						   (connection ?z ?y)))
				      ?set2))
			(cardinality ?set2 6)))
	   ?set1))
	 (cardinality ?set1 ?n))
       :comment "How many nodes are two nodes from six nodes ?")))

;;; BUG:  This is creating set frames with multiple cardinalities.
