;;; -*- Mode:Common-Lisp; Package:USER; Syntax:COMMON-LISP; Base:10 -*-

;;; First steps toward an Algernon problem solver.

;;; The basic heuristic here is: Assume negation of result, then query negation
;;; of known facts.

;;; For Bank problem 'negation of result' means to assume each possible coreference
;;; and the query negation of facts.

;;; Coref-Tester: Takes two sets and a set of facts, and assumes each possible
;;; coreference in turn and queries paths.

;;; We use the Algernon function negate (which should probably be part of the lisp
;;; interface of Algernon anyway).

;;; Note: We expect set1 and set2 to be sets of FRAMES (not names of frames).

(defun coref-tester (set1 set2 paths)
  (dolist (e1 set1)
    (dolist (e2 set2)
      (let ((pred `(coreferent (:quote ,e1) (:quote ,e2))))
	(unless (or (s-query (list pred))
		    (s-query (list (negate pred))))
	  (s-assume pred)
	  (mapc #'s-query paths)
	  (s-unassume pred))))))

;;; S-Assume, S-Query, and S-Unassume: Interface between solver and Algernon.

(defun s-assume (pred)
  (a-assert (format nil "Problem solver adding assumption ~(~a~)." pred)
	    `((:assume ,pred))))

(defun s-query (path)
  (a-query "Problem solver query."
	   path))

(defun s-unassume (pred)
  (if (s-assump-p pred)
      (a-assert (format nil "Problem solver retracting assumption ~(~a~)." pred)
		`((:delete ,pred)))))

;;; We can recognize solver assumptions because they are tagged with themselves.
;;; This routine uses the Algernon preprocessor should perhaps migrate into Algernon.
(defun s-assump-p (pred)
  (let ((prep-pred (car (preprocess (list pred)))))
    (a-query (format nil "Problem solver checking to see that ~(~a~) is an assumption." pred)
	     (list pred))
    (and (eql (length *last-results*) 1)
	 (member (list prep-pred) (aresult-assump-ll (car *last-results*)) :test #'equal))))