
;;; Solution to YSP.

(defun situations ()
  (a-assert "Taxonomy"
            '((:taxonomy (objects (models)
                                  (states s0 s1 s2 s3 s4 s5)
                                  (events e1 e2 e3 e4 e5)
                                  (processes)
                                  (features)
                                  (values (booleans))))))
  (a-assert "Slots"
            '(;; First we link states and events:
              (:slot next-state (states states)
                     :cardinality 1)
              (:slot prev-state (states states)
                     :cardinality 1)
	      (inverse prev-state next-state)
              (:slot event (states events)
                     :cardinality 1)
              (:slot init-state (events states)
                     :cardinality 1)
	      (inverse init-state event)
              (:slot result-state (events states)
                     :cardinality 1)
              (:slot prev-event (states events)
                     :cardinality 1)
	      (inverse prev-event result-state)
              
              (:slot status (states features values)
                     :comment "Description of state.")
              
              (:slot active (events processes)
                     :comment "Processes active durrent event")
              (:slot affects (nil features)
                     :comment "Features effected by processes and events.")

              (:slot complete-model (models booleans)
                     :cardinality 1)
              (:slot model-proc (models events processes))
              (:slot current-model (contexts models))))

  (a-assert "A value can't be both false and true."
            '((:rules states
                      ((status ?s ?f true) -> (not (status ?s ?f false)))
                      ((status ?s ?f false) -> (not (status ?s ?f true))))))
  
  (a-assert "Rules to link states and events."
            '((:rules states
                      ((event ?s1 ?e) (result-state ?e ?s2) -> (next-state ?s1 ?s2))
                      ((next-state ?s1 ?s2) (prev-event ?s2 ?e) -> (event ?s1 ?e))
                      ((event ?s1 ?e) (next-state ?s1 ?s2) -> (result-state ?e ?s2)))))

  (a-assert "Modeling assumption."
            '((:rules events
                      ;; All active processes are in the model:
                      ((active ?e ?p)
		       (current global-context ?cc)
                       (current-model ?cc ?cm)
                       (:unp (model-proc ?cm ?e ?p))
                       ->
                       (not (complete-model ?cm true))))))

  (a-assert "Simlulation assumption."
            '((:rules events
                      ;; Any feature not effected by a process is constant:
                      ((not (affects ?e ?f))
                       <-
                       (:unp (affects ?e ?f))
		       (current global-context ?cc)
                       (current-model ?cc ?cm)
                       (complete-model ?cm true)
                       (:assume (not (affects ?e ?f))))
                      ;; Any feature effected by a process is effected by some active process:
                      ((affects ?e ?f)
                       ->
                       (:forc ?p
                              (active ?e ?p) (affects ?p ?f))))))

  (a-assert "Model building"
            '((:rules models
                      ((model-proc ?m ?e ?p)
                       ->
                       (active ?e ?p)))))

  (a-assert "Simluating"
            '((:rules states
                      ;; Copy over unchanged features:
                      ((status ?s1 ?f ?v) (event ?s1 ?e) (not (affects ?e ?f)) (next-state ?s1 ?s2)
                       ->
                       (status ?s2 ?f ?v)))))
  
  (a-assert "Set up some states."
            '((next-state s0 s1)
              (next-state s1 s2)
              (next-state s2 s3)
              (next-state s3 s4)
              (next-state s4 s5)
              (event s0 e1)
              (event s1 e2)
              (event s2 e3)
              (event s3 e4)
              (event s4 e5))))

(defun facts-about-ysp ()
  (situations)

  (a-assert "The ysp"
            '((:a ?c (name ?c "YSP-CONTEXT"))
              (current global-context ?c)))	      
  
  (a-assert "Fill in taxonomy"
            '((:taxonomy (processes loading shooting waiting))
              (:taxonomy (features alive loaded))))

  (a-assert "Define processes"
            '((affects loading loaded)
              (affects shooting alive)
              
              (:rules events
                      ((active ?e loading) (result-state ?e ?s2)
                       ->
                       (status ?s2 loaded true))
                      ((active ?e shooting)
                       (init-state ?e ?s1) (status ?s1 loaded true)
                       (result-state ?e ?s2)
                       ->
                       (status ?s2 alive false)))))

;;  (trace-interest)

  (a-assert "The model."
            '((:a ?m (name ?m "MODEL"))
              (current-model ysp-context ?m)
              (model-proc ?m e1 loading)
              (model-proc ?m e2 waiting)
              (model-proc ?m e3 shooting)

              (:assume (complete-model ?m true))

              (status s0 alive true)
              (status s0 loaded false))))
