;;; Common things, from the Algernon v2.0 "akbase.lisp"
;;; (mh) 5 Sep 1996

(in-package :CL-USER)


(when (fboundp 'CL-USER::ALGY-NOTE-LOADED-KB)
  (algy-note-loaded-kb :COMMON))


(defun akb-common-things ()

  (aam:with-aam-silent         ;; We don't want output from these assertions.

    (tell '((:taxonomy (things
			(objects
			 (booleans true false :complete)
			 (physical-attributes
			  (colors black white red blue green
				  yellow brown orange purple)
			  (genders male female :complete))
			 (physical-objects
			  (people))))))
	  :comment "Taxonomy for common things.")

    ;; Color and Gender slots
    (tell '((:slot color  (physical-objects colors))
	    (:slot gender (physical-objects genders))
	    ))
	  
    (tell '((cardinality color  1)
	    (cardinality gender 1)
	    ))
  
    ;;Spouse, Wife, Husband, Friend
    ;; These need to be physical-objects because 'gender' is defined
    ;; for physical objects.  The type checking in the compiler gives
    ;; an error for using the same variable for gender and wife if they
    ;; are not the same type.
    (tell '((:slot spouse  (people people))
	    (:slot wife    (people people))
	    (:slot husband (people people))
	    (:slot friend  (people people))))

    (tell  '((cardinality    spouse  1)
	     (cardinality    wife    1)
	     (cardinality    husband 1)
	     (inverse spouse spouse)
	     (generalization wife    spouse)
	     (generalization husband spouse)
	     (inverse wife   husband)))


    (tell  ;; Necessary and sufficient conditions for husband and wife.
           '((:rules people
	     ((wife ?x ?p1)    -> (gender ?p1 female))
	     ((wife ?x ?p1)    <- (spouse ?x ?p1) (gender ?p1 female))
	     ((husband ?x ?p1) -> (gender ?p1 male))
	     ((husband ?x ?p1) <- (spouse ?x ?p1) (gender ?p1 male))
	     )))


    ;; Context-related info
    (tell '((:slot super-context (contexts contexts))
	    (:slot sub-context   (contexts contexts))
	    (:slot current       (contexts contexts))
	    (:slot speaker       (contexts people))
	    (:slot recent        (contexts objects))
	    ))

    (tell '((cardinality current 1)
	    (cardinality speaker 1)

	    (:srules (:slot current)
	     ((current ?context1 ?context2)
	      ->
	      (super-context ?context2 ?context1))

	     ((not (current ?context1 ?context2))
	      ->
	      (not (super-context ?context2 ?context1))))


	    )
	  )


    (tell '((inverse sub-context super-context)))
    )
  )


(akb-common-things)

(format *trace-output* "~%Algernon Common KB loaded.~%")
