;;; this is the AAM core KB

(in-package :CL-USER)

(when (fboundp 'CL-USER::ALGY-NOTE-LOADED-KB)
  (algy-note-loaded-kb :CORE))


#|
 Appendix A:
Knowledge Base Initialization The following forms will initialize the
knowledge base so that A-L-L reasoning can begin.  These forms are written
using the Generic Frame Protocol.  In addition to the code shown below, ALL
requires that the base types :number, :string, :symbol and :list be
defined.
|#
;;;  The following code initializes a knowledge base
;;;  using GFP commands.  This code must be processed
;;;  by the abstract machine before it can process
;;;  any user-level code.



(aam:with-aam-silent         ;; We don't want output from these assertions.

;;;  create the basic facets

(GFP:create-facet 'value             NIL NIL) ;; (slot frame <value>)
(GFP:create-facet 'n-value           NIL NIL) ;; (not (slot frame <value>))
(GFP:create-facet 'if-added          NIL NIL) ;; Forward-chaining rules
(GFP:create-facet 'n-if-added        NIL NIL) ;; FC on (not ...)
(GFP:create-facet 'if-needed         NIL NIL) ;; Backward-chaining rules
(GFP:create-facet 'n-if-needed       NIL NIL) ;; BC on (not ...)

(GFP:create-facet 'slot-if-added     NIL NIL) ;; Forward-chaining on slots
(GFP:create-facet 'slot-n-if-added   NIL NIL) ;; FC on slot (not ...)
(GFP:create-facet 'slot-if-needed    NIL NIL) ;; Backward-chaining on slots
(GFP:create-facet 'slot-n-if-needed  NIL NIL) ;; BC on slot (not ...)

(GFP:create-facet 'self-if-added     NIL NIL) ;; Rule Continuations
(GFP:create-facet 'self-n-if-added   NIL NIL) ;; Rule Continuations,  (not ...)

(GFP:create-facet 'cache-if-added     NIL NIL) ;; Forward-chaining on slots
(GFP:create-facet 'cache-n-if-added   NIL NIL) ;; FC on slot (not ...)
(GFP:create-facet 'cache-if-needed    NIL NIL) ;; Backward-chaining on slots
(GFP:create-facet 'cache-n-if-needed  NIL NIL) ;; BC on slot (not ...)

(GFP:create-facet 'cache-slot-if-added     NIL NIL) ;; Forward-chaining on slots
(GFP:create-facet 'cache-slot-n-if-added   NIL NIL) ;; FC on slot (not ...)
(GFP:create-facet 'cache-slot-if-needed    NIL NIL) ;; Backward-chaining on slots
(GFP:create-facet 'cache-slot-n-if-needed  NIL NIL) ;; BC on slot (not ...)

(GFP:create-facet 'queries            NIL NIL) ;; Storage for Query History

		     
;;;  create the basic slots

(with-no-rule-caching     ;; We don't have enough info yet...
    (let ((aam::*forward-chain*   NIL)
	  (aam::*backward-chain*  NIL)
	  (*check-slot-domains*   NIL))

(tell '((:slot isa    (things sets))
	(:slot name   (things :string))
	(:slot arity  (Slots :NUMBER))
	))

;; Generic must come before the first time we do an assert,
;; which comes in the next 'tell' after this.

(tell '((:slot generic  (things rules))
	(arity isa      2)             ;; the ARITY slot wasn't available above...
	(arity name     2)             ;; so we assert these by hand.
	))


;;;  Bootstrap the top of the hierarchy
;;;  We have to be careful to not use slots that aren't defined yet.

(SFS:kb-def-frame 'things)
(SFS:kb-def-frame 'slots)
(SFS:kb-def-frame 'rules)
(SFS:kb-def-frame 'objects)
(SFS:kb-def-frame 'physical-objects)
(SFS:kb-def-frame 'booleans)

(SFS:kb-def-frame 'true)
(SFS:kb-def-frame 'false)


;;;  IMP-SUPERSET is related to activation of rules and 
;;;  propagation of the ISA relation.

(tell '((:slot imp-superset (sets sets))))     ;; taxonomy

;;;  Slots related to the inheritance hierarchy

(tell '((:slot member (sets things))))

;;;  Define the major class/subclass relation
(tell '((:slot   subset     (sets sets))       ;; class/subclass
        (:slot   superset   (sets sets))
	))

))  ;; end of WITH-NO-RULE-CACHING

;;; --------  Done with important bootstrapping  ---------------


(let ((*check-slot-domains*  NIL))    ;; Don't have enough info to check yet.

;;; 'cardinality' and 'inverse' are already defined as
;;; facets in GFP, but A-L-L views them as slots.

(tell '((:slot cardinality    (Slots :NUMBER))
        (:slot inverse        (Slots Slots))
	(:slot complete       (Sets  Booleans))
	(:slot generalization (Slots Slots))
	))

(tell '((inverse subset     superset)
        (cardinality cardinality 1)
        (cardinality inverse     1)
	))



;;;; In Algernon, Rules and Rule Continuations are stored
;;;; in the knowledge base on frames and facets of frames. 
;;;; So the components of a rule are stored in slots.

;;;  slots related to rule components

(GFP:create-class 'directions  '(objects))
(GFP:create-instance '-> '(directions))
(GFP:create-instance '<- '(directions))

(tell '((:slot antecedent   (rules  :LIST))
        (:slot consequent   (rules  :LIST))
        (:slot code         (rules  :LIST))
        (:slot direction    (rules  directions))
        (:slot index        (rules  :NUMBER))
        (:slot key          (rules  :LIST))
        (:slot root         (rules  :SYMBOL))
        (cardinality antecedent 1)
        (cardinality consequent 1)
        (cardinality direction  1)
        (cardinality key        1)
        (cardinality index      1)
        (cardinality root       1)))


;;;; Relations between rules and rule continuations

(tell '((:slot       instance-of  (rules  rules))
        (cardinality instance-of  1)
	(:slot       disjoint     (sets   sets))))

;;; Now we can create some rules     The DEFAULT RULES

;;;  For every 'member' link we want an 'isa' link, but
;;;  not necessarily vice-versa.  So we don't make
;;;  'member' and 'isa' be inverses.

(tell '((:srules member
		 ((member ?set ?x) -> (isa ?x ?set))
		 ((not (member ?f1 ?f2)) -> (not (isa ?f2 ?f1))))))


;;;  This rule propagates inverse links.
(tell '((:srules SLOTS
                 ((inverse ?s1 ?s2)
                  ->
                  (:SRULES ?s1 ((?s1 ?x ?y) -> (?s2 ?y ?x)))
                  (:SRULES ?s1 ((not (?s1 ?x ?y)) -> (not (?s2 ?y ?x))))
                  
                  (:SRULES ?s2 ((?s2 ?y ?x) -> (?s1 ?x ?y)))
                  (:SRULES ?s2 ((not (?s2 ?y ?x)) -> (not (?s1 ?x ?y))))
                  )
                 )))


;;;  This rule propagates a "one-way" inverse link for imp-superset.
(tell '((:srules IMP-SUPERSET
                 ((imp-superset ?s1 ?s2)
                  ->
                  (subset ?s2 ?s1)))))

;; Important transitive closure of imp-superset
(tell '((:srules IMP-SUPERSET
		 ((imp-superset  ?a ?b)
		  (imp-superset  ?b ?c)
		  ->
		  (imp-superset ?a ?c)))))


;; The Generalization slot implements a hierarchy of slots.
;; For example, 'spouse' is a generalization of 'wife'
(tell '((:srules generalization
		 ((generalization ?P1 ?P2)
		  (arity ?P1 2)
		  (arity ?P2 2)
		  ->
		  (:srules ?P1
			   ((?P1 ?x1 ?x2) -> (?P2 ?x1 ?x2)))))

	(:srules generalization
		 ((generalization ?P1 ?P2)
		  (arity ?P1 3)		; and similar for arities 3,4,5.
		  (arity ?P2 3)
		  ->
		  (:srules ?P1
			   ((?P1 ?x1 ?x2 ?x3) -> (?P2 ?x1 ?x2 ?x3)))))

	(:srules generalization
		 ((generalization ?P1 ?P2)
		  (arity ?P1 4)		; and similar for arities 3,4,5.
		  (arity ?P2 4)
		  ->
		  (:srules ?P1
			   ((?P1 ?x1 ?x2 ?x3 ?x4) -> (?P2 ?x1 ?x2 ?x3 ?x4)))))

	(:srules generalization
		 ((generalization ?P1 ?P2)
		  (arity ?P1 5)		; and similar for arities 3,4,5.
		  (arity ?P2 5)
		  ->
		  (:srules ?P1
			   ((?P1 ?x1 ?x2 ?x3 ?x4 ?x5) -> (?P2 ?x1 ?x2 ?x3 ?x4 ?x5)))))
	))




;;; Note:  The following rule was removed  8 Oct 1996  because the
;;;        new rule caching mechanism does not require it.

;;;  This rule propagates the ISA relationship via the imp-superset relation.
;;(tell '((:srules ISA
;;                 ((isa ?x ?a)
;;                  (imp-superset ?a ?b)
;;                  ->
;;                  (isa ?x ?b)))))




;;; Now reassert the taxonomy to get all the necessary relations defined.

;;; It is okay to reassert the classes because GFP:CREATE-CLASS
;;; will reuse the old frame.  But we need to get rid of the
;;; instances before we do the taxonomy.  Otherwise we get
;;; frames like 'TRUE1' and '->1'

;;; Instances
(sfs::kb-delete-values 'directions 'member)   ;; Delete links to ->   and <-
(sfs::kb-delete-values 'booleans   'member)   ;; Delete links to TRUE and FALSE

(SFS:kb-delete-frame '->)
(SFS:kb-delete-frame '<-)
(SFS:kb-delete-frame 'TRUE)
(SFS:kb-delete-frame 'FALSE)


;; Re-create the taxonomy
;; This should cause rules to fire.
(GFP:create-class  'things   NIL)    ;; The two key classes.
(GFP:create-class  'sets     NIL)

(tell '((:taxonomy (things
		    (slots)
		    (sets)
		    (rules)
		    (objects
		     (sets things objects sets slots)
		     (booleans false true :complete)
		     (contexts global-context)
		     (directions  ->   <-    :complete)
		     (physical-objects))
		    ))))


;; The imp-superset links came in "too late" for frames created in
;; bootstrapping so we have to add isa links explicitly:
;;

(tell '(
	(isa things  objects)
	(isa objects objects)
	(isa sets    objects)
	(isa slots   objects) 

	(isa things  things)
	(isa objects things)
	(isa sets    things)
	(isa slots   things) 

	(isa things  sets)
	(isa objects sets)
	(isa sets    sets)
	(isa slots   sets) 

;;	(isa isa           things)
;;	(isa name          things)
;;	(isa inverse       things)
;;	(isa member        things)
;;	(isa subset        things)
;;	(isa superset      things)
;;	(isa imp-superset  things)
;;	(isa disjoint      things)
	)
      :comment "Algernon Core KB loaded.")


;;; Delete some inconsistencies
(tell '((:delete (not (isa things  objects)))
	(:delete (not (isa things  sets)))
	(:delete (not (isa objects sets)))
	))


) ;; End of let .. *check-slot-domains* NIL

) ;; End of WITH-AAM-SILENT
