(in-package :cl-user)

;;; Copyright (c) 1990 by James Crawford.
;;;  $Id: akbase.lisp,v 1.3 1993/06/17 13:39:09 kuipers Exp $


;;; The set theory portion of the Algernon v2.0 "akbase.lisp".



(defun akb-set-theory ()

  (tell '((:taxonomy (things
		      (rules)
		      (objects
		       (sets things objects sets slots)
		       (booleans true false :complete)
		       (contexts global-context))
		      (slots
		       (order-relations
			(tc-order-relations
			 (equivalence-relations)))))))
	:comment "Taxonomy.")



  ;; From here we define slots and rules for each set.

  ;; SETS.
  ;;
  ;; Several important slots for sets were actually defined above:
  ;;   (isa x s) = x is a member of s.
  ;;   (member s x) = A member of s is x.
  ;;   (subset s1 s2)      = A subset of s1 is s2. 
  ;;   (superset s1 s2)    = A superset of s1 is s2.
  ;;   (imp-superset s1 s2) = Important superset.
  ;;
  ;;
  (tell '(;; Subset and superset:
	  (isa (:slot subset) order-relations)
	  (isa (:slot superset) order-relations)
	  
	  (:slot union-of (sets sets)
	   :cardinality 2
;;	   :backlink superset
	   :comment "(union-of s1 s2)    = s1 is union of s2 with other set in slot.")
	  ;;Replace :BACKLINK with rules
	  (:srules (:slot union-of)
		   ((union-of ?set1 ?set2)
		    ->
		    (superset ?set2 ?set1))
		   ((not (union-of ?set1 ?set2))
		    ->
		    (not (superset ?set2 ?set1))))

	  ;;
	  (:slot intersection-of (sets sets)
	   :cardinality 2
;;	   :backlink subset
	   :comment
	   "(intersection-of s1 s2) = s1 is intersection of s2 with other set in slot.")

	  ;;Replace :BACKLINK with a rule
	  (:srules (:slot intersection-of)
		   ((intersection-of ?set1 ?set2)
		    ->
		    (subset ?set2 ?set1))
		   ((not (intersection-of ?set1 ?set2))
		    ->
		    (not (subset ?set2 ?set1))))
	  
	  ;; Note: Need to unify `intersect-sub' with rest of representation.
	  (:slot intersect-sub (sets sets sets)
	   :comment "(intersect-sub s1 s2 s3) = (s1 <intersect> s2) <subset> s3")
	  ;; intersect-sub has a strange sort of "backlink":
	  (:SRULES (:slot intersect-sub)
	   ((intersect-sub ?s1 ?s2 ?s3) -> (intersect-sub ?s2 ?s1 ?s3)))
	  
	  (:slot total (sets booleans)
;;	   :backlink total
	   :comment "(total s1 s2)       = s1 union s2 contains all things.")
	  ;;Replace :BACKLINK with a rule
	  (:srules (:slot total)
		   ((total ?set ?val)
		    ->
		    (total ?val ?set))
		   ((not (total ?set ?val))
		    ->
		    (not (total ?val ?set))))
	  ;;
	  (:slot disjoint (sets sets)
;;	   :backlink disjoint
	   :comment "(disjoint s1 s2)    = s1 and s2 are disjoint.")
	  ;;Replace :BACKLINK with a rule
	  (:srules (:slot disjoint)
		   ((disjoint ?set1 ?set2)
		    ->
		    (disjoint ?set2 ?set1))
		   ((not (disjoint ?set1 ?set2))
		    ->
		    (not (disjoint ?set2 ?set1))))
	  ;;
	  (:slot complement (sets sets)
	   :cardinality 1
;;	   :backlink complement
	   :comment "(complement s1 s2)  = The complement of s1 is s2.")
	  ;;Replace :BACKLINK with a rule
	  (:srules (:slot complement)
		   ((complement ?set1 ?set2)
		    ->
		    (complement ?set2 ?set1))
		   ((not (complement ?set1 ?set2))
		    ->
		    (not (complement ?set2 ?set1))))

	  (:slot cf-member (things sets)
		   :comment
		"(cf-member x s)     = x is coreferent with some member of s.")
	      ;;
	  (:slot one-to-one-into (sets sets)
		   :comment "(one-to-one-onto s1 s2) = All members of s1 ~
                              are coreferent with some member of s2.")
	      ;;
	  (:slot one-to-one (sets sets)
		   :comment "Bi-directional one-to-one-into.")
	      ;; 
	  (:SRULES (:slot one-to-one)
	   ((one-to-one ?s1 ?s2) -> (one-to-one-into ?s1 ?s2)
	    (one-to-one-into ?s2 ?s1)))
	  ;;
	  )
	:comment "Sets.")

  (tell '((disjoint slots objects)
	  ;;
	  ;; Internally slotp is checked using the slotp property
	  ;; (this should probably change):
	  (:rules slots
	   ((isa ?slot slots) -> (:eval (declare-system-slot '?slot)))))
	:comment "Slots")


  (tell '((:RULES sets
	   ;; Rules for deducing relationships between sets
	   ;;   complement = disjoint and total.
	   ((complement ?s1 ?s2) <- (disjoint ?s1 ?s2) (total ?s1 ?s2))
	   ((complement ?s1 ?s2) -> (disjoint ?s1 ?s2) (total ?s1 ?s2))
	   ;;
	   ;; Then ways for deducing membership
	   ;; (this first rule is actually subsumed by subset rule below)
	   ;;   In the union if in one of the unioned sets:
	   ;;((member ?s0 ?x) <- (union-of ?s0 ?s1) (member ?s1 ?x))
	   ;;   Must be in both sets to be in the intersection.
	   ((member ?s0 ?x) <- (intersection-of ?s0 ?s1) (intersection-of ?s0 ?s2) (:NEQ ?s1 ?s2)
	    (member ?s1 ?x) (member ?s2 ?x))
	   ;;   If two sets are total then have to be in one or the other.
	   ((member ?s0 ?x) <- (total ?s0 ?s2) (not (member ?s2 ?x)))
	   ;;   In a set if in one of its subsets.
	   ((member ?s0 ?x) <- (subset ?s0 ?s2) (member ?s2 ?x))
	   ;;
	   ;; And the corresponding ways of deducing non-membership (see comments
	   ;; above).
	   ;; (again first rule subsumed)
	   ;;((not (member ?s0 ?x))  <- (intersection-of ?s0 ?s1) (not (member ?s1 ?x)))
	   ((not (member ?s0 ?x)) <- (union-of ?s0 ?s1)
	                             (union-of ?s0 ?s2)
	                             (:NEQ ?s1 ?s2)
   	                             (not (member ?s1 ?x))
	                             (not (member ?s2 ?x)))
	   ((not (member ?s0 ?x)) <- (disjoint ?s0 ?s2) (member ?s2 ?x))
	   ((not (member ?s0 ?x)) <- (superset ?s0 ?s2) (not (member ?s2 ?x)))
	   ;;
	   ;; An important property of complete sets:
	   ;;   If a set is complete and it is consistent to assume x is
	   ;;   not a member then assume x is a non-member.
	   ;; (an alternative here would be to assume ?x not coreferent with
	   ;;  all members of the set).
	   ((not (member ?s0 ?x)) <- (complete ?s0 true)
	    (:ASSUME (not (member ?s0 ?x))))
	   ;;
	   ;; Can deduce isa by following superset:
	   ((isa ?x ?s2) <- (:boundp ?s2) (isa ?x ?s1) (superset ?s1 ?s2))
	   ;;
	   ;; Can deduce one-to-one:
	   ((one-to-one ?s1 ?s2) <- (one-to-one-into ?s1 ?s2) (one-to-one-into ?s2 ?s1)))

	  ;; Create a selfset on demand.
	  (:SRULES selfset
	   ((selfset ?f ?s) <- (:a ?s (selfset ?f ?s)))
	   ((selfset ?f ?s) -> (isa ?s Sets)
	                       (isa ?f ?s)
	                       (member ?s ?f)
			       (complete ?s true)))
	  
	  (:RULES objects
	   ;; Can deduce cf-member:
	   ((cf-member ?x ?s1) <- (isa ?x ?s2) (one-to-one-into ?s2 ?s1))))
	:comment "Rules for sets")
  )


(akb-set-theory)
