;;;; -*- Mode:Lisp; Package:CL-USER; Syntax:COMMON-LISP; Base:10 -*-

(in-package :GFP)

;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; Copyright (c) 1996 by Micheal Scott Hewett
;;;
;;; This code may be used by anyone for any project, but may not
;;; be sold in source or object form without permission.
;;; If in doubt, follow the GNU "copyleft" guidelines.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; (Contact: hewett@cs.utexas.edu or hewett@cs.stanford.edu)
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;;
;;;  Simple, incomplete Generic Frame Protocol interface to
;;;  the Simple Frame System.  Functions:
;;;
;;;      ADD-FACET-VALUE (frame slot facet value)
;;;      CREATE-CLASS    (class superiors)
;;;      CREATE-FACET    (name  &OPTIONAL (ignore1 ignore2))
;;;      CREATE-INSTANCE (name class)
;;;      CREATE-SLOT     (name domains)
;;;      GET-FACET-VALUES (frame slot facet value)
;;;  
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

#+GCL
(export '(gfp::ADD-FACET-VALUE
	  gfp::CREATE-CLASS
	  gfp::CREATE-FACET
	  gfp::CREATE-INSTANCE
	  gfp::CREATE-SLOT
	  gfp::GET-FACET-VALUES
	  )
	(find-package :GFP)
	)
 


(defun ADD-FACET-VALUE (frame slot facet value)

  ;;; Fix up the value parameter, if necessary, to keep
  ;;; consistency between binary relations and n-ary relations.
  
  (unless (listp value)
    (setq value (list value)))

  (SFS:kb-put-value frame slot facet value)
  )
  

(defun CREATE-CLASS    (class direct-supers)

  ;; It's okay if we are redefining a class - we'll just
  ;; reuse the previous class frame.  However, we don't
  ;; want to reuse instance frames.

  (let ((new-frame  (if (sfs::kb-frame-p class)
			class
		      ;;ELSE - CREATE=NIL means use existing frame if any
		      (SFS:kb-def-frame class
					:CREATE NIL)))
	)

    (CL-USER::tell `((CL-USER::name ,new-frame ,(string new-frame))))

    ;;; We need to assert IMP-SUPERSET links using TELL
    ;;; so that rules will fire.
    (dolist (super direct-supers)
      (CL-USER::tell `((CL-USER::imp-superset ,new-frame ,super))))

    new-frame
    )
  )
  

(defun CREATE-FACET    (name  &OPTIONAL frame slot)

  (declare (ignore frame slot))

  (SFS:kb-def-facet name)
  )


(defun CREATE-INSTANCE (name direct-type-or-types)

  (unless (listp direct-type-or-types)
    (setq direct-type-or-types (list direct-type-or-types)))

  (let ((new-frame (SFS:kb-def-frame name))  ;; possibly renames frame
	)

    (CL-USER::tell `((CL-USER::name ,new-frame ,(string new-frame))))

    ;;; We need to assert member links using TELL
    ;;; so that rules will fire.
    (dolist (type direct-type-or-types)
      (CL-USER::tell `((CL-USER::member ,type      ,new-frame)))
      )

    new-frame
    )
  )


(defun CREATE-SLOT     (name domains)

  (SFS:kb-def-slot name domains)
  )
  

(defun GET-FACET-VALUES (frame slot facet)

  (SFS:kb-get-values frame slot facet)
  )
