;;;; -*- Mode:Lisp; Package:CL-USER; Syntax:COMMON-LISP; Base:10 -*-

(in-package :CL-USER)

;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; Copyright (c) 1996 by Micheal Scott Hewett
;;;
;;; This code may be used by anyone for any project, but may not
;;; be sold in source or object form without permission.
;;; If in doubt, follow the GNU "copyleft" guidelines.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; (Contact: hewett@cs.utexas.edu or hewett@cs.stanford.edu)
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;;
;;;  A file that loads all the GFP files.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 



(defparameter *ALL-GFP-FILES*
    '("gfp-package"
      "gfp-sfs")
    )


(defun load-or-compile-gfp ()

  (if (check-file-mod-times *ALL-GFP-FILES*)
      (progn
	(format *trace-output* "~2%Some GFP source files have been updated.")
	(format *trace-output* "~%Compiling and loading GFP...")
	(compile-gfp))
    ;;else
    (progn
      (format *trace-output* "~2%Loading GFP...")
      (load-gfp)
      )
    )

  (format t "~%GFP-SFS 1.0 loaded.")
  )



(defun compile-gfp ()

  (dolist (filename *ALL-GFP-FILES*)
    (load-algy-source-file filename))

  ;; Compile GFP

  (dolist (filename *ALL-GFP-FILES*)
    (compile-algy-file filename))

  (load-gfp)
  )


;;; LOAD-SFS

(defun load-gfp ()

  (dolist (filename *ALL-GFP-FILES*)
    (load-algy-file filename))
  )
