;;;; -*- Mode:Lisp; Package:AAM; Syntax:COMMON-LISP; Base:10 -*-

(in-package :AAM)

;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; Copyright (c) 1996 by Micheal Scott Hewett
;;;
;;; This code may be used by anyone for any project, but may not
;;; be sold in source or object form without permission.
;;; If in doubt, follow the GNU "copyleft" guidelines.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; (Contact: hewett@cs.utexas.edu or hewett@cs.stanford.edu)
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;;
;;;  User-settable variables and functions.
;;;
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


;;; This list has each opcode, its number of args, and
;;; the name of the processor function that handles it.

(defparameter *SEARCH-CONTROL-TYPE*  :DEPTH-FIRST
  "Can be :DEPTH-FIRST, :BREADTH-FIRST, or :BEST-FIRST.
If :BEST-FIRST, user supplies a queue insertion function.")

(defparameter *QUEUE-INSERTION-FUNCTION*  'insert-depth-first
  "Takes args (ITEM), where ITEM is (<path> <binding-list> <code>).")
    


;;; ------------  FUNCTIONS  ------------

(defun add-to-action-queue (item)
  "Item is a 3-element list: (path binding-list code)."
  
  ;;; Adds the item to the ACTIONS register.
  
  (case *SEARCH-CONTROL-TYPE*

    (:DEPTH-FIRST     (push item *R-ACTIONS*))

    (:BREADTH-FIRST   (if (null *R-ACTIONS*)
			  (push item *R-ACTIONS*)
			;;ELSE
			  (nconc *R-ACTIONS* (list item))))

    (:BEST-FIRST      (funcall *queue-insertion-function* item *R-ACTIONS*))
    )
  )
			       

(defun insert-depth-first (item)

  (push item *R-ACTIONS*)
  )

