;;;; -*- Mode:Lisp; Package:AAM; Syntax:COMMON-LISP; Base:10 -*-

(in-package :AAM)

;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; Copyright (c) 1996 by Micheal Scott Hewett
;;;
;;; This code may be used by anyone for any project, but may not
;;; be sold in source or object form without permission.
;;; If in doubt, follow the GNU "copyleft" guidelines.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; (Contact: hewett@cs.utexas.edu or hewett@cs.stanford.edu)
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;;
;;;  Preprocessor for the AAM compiler.
;;;
;;;  AAM needs a preprocessor because some special forms
;;;  expand to lower-level forms.  For example:
;;;
;;;   (:FORC ?x <path>) expands to  ((:UNP     <path>)
;;;                                  (:A   ?x  <path>))
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


(defparameter *prep-changed* NIL "Used to terminate loop in preprocess.")


;;; old version
#|

(defun preprocess (path)
  "Returns a new path."

  (mapcan #'preprocess-clause path)
  )


(defun preprocess-clause (clause)

  (if (symbolp clause)
      (list clause)
    ;;else
    (cond ((and (consp (frame clause))
		(eq (car (frame clause)) :SLOT))

	   (if (negated-p clause)
	       (setf (second (second clause))
		 (second (frame clause)))
	     ;;ELSE
	     (setf (second clause)
	       (second (second clause)))
	     )
	   (preprocess (list clause))
	   )

	  ((eq (slot clause) :SCHEMA)     ;; Ignore :SCHEMA for now.
	   (preprocess (cddr clause)))

	  ((eq (slot clause) :ASSUME)     ;; Ignore :ASSUME for now.
	   (preprocess (cdr clause)))

	  ((member (slot clause) '(:RULES :SRULES))
	   (list (cons (slot clause)
		       (cons (frame clause)
			     (list (mapcan #'preprocess (cddr clause)))))))

	  (T  (list clause))
	  )
    )
  )
|#


(defun preprocess (thing)
  "Input is usually a path.  Returns a new path."

  (cond ((symbolp thing)       thing)

	((consp (car thing))   (mapcar #'preprocess-clause thing))  ;; a path

	(T  (mapcar #'preprocess thing))
	)
  )


(defun preprocess-clause (clause)

  (if (symbolp clause)
      clause
    ;;else
    (cond ((and (consp (frame clause))
		(eq (car (frame clause)) :SLOT))

	   (if (negated-p clause)
	       (setf (second (second clause))
		 (second (frame clause)))
	     ;;ELSE
	     (setf (second clause)
	       (second (second clause)))
	     )
	   (preprocess-clause clause)
	   )

	  ((eq (slot clause) :SCHEMA)     ;; Ignore :SCHEMA for now.
	   (preprocess (cddr clause)))

	  ((eq (slot clause) :ASSUME)     ;; Ignore :ASSUME for now.
	   (preprocess-clause (second clause)))

	  ((member (slot clause) '(:RULES :SRULES))
	   (cons (slot clause)
		 (cons (frame clause)
		       (mapcar #'preprocess (cddr clause)))))

	  ((eq (slot clause)     :W-CONTRA-POSITIVE)
	   (preprocess-clause (second clause)))

	  (T  clause)

	  )
    )
  )

