;;;; -*- Mode:Lisp; Package:AAM; Syntax:COMMON-LISP; Base:10 -*-

(in-package :AAM)

;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; Copyright (c) 1996 by Micheal Scott Hewett
;;;
;;; This code may be used by anyone for any project, but may not
;;; be sold in source or object form without permission.
;;; If in doubt, follow the GNU "copyleft" guidelines.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; (Contact: hewett@cs.utexas.edu or hewett@cs.stanford.edu)
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;;
;;;  User-level printing routines for the AAM
;;;  Copied from Algernon v2.0 "aprint.lisp" with
;;;  some modifications.
;;;
;;; ------------------------------------------------------------


(defparameter *indent-level*        0)
(defparameter *white-space*         2)

(defparameter *data-column*        23)
(defparameter *data-column2*     (+ 7 *data-column*))




;;;  ----  Showing results of TELL or ASK
;;;  taken from Algernon v2.0, with some mods.


(defun post-op (op values-and-bindings &key eval collect)

  (declare (ignore op))

  ;;; Input is  ((value . binding-set)
  ;;;            (value . binding-set) ...)

  ;; Translate variables into internal Algernon variables:
  
  (when eval
    (dolist (value-and-binding-set values-and-bindings)
      (eval (sublis (cadr value-and-binding-set) eval)))
    )
    
  ;; (bug fixed, 10 Apr 1997 (mh)) 
  ;; there should only be one binding list per result now
  ;; so we don't need to mapcar over the binding set.

  (cond (collect
	 (mapcar #'(lambda  (value-and-bset)
		     (sublis (second value-and-bset) collect))
		 values-and-bindings))
	
	(t (some #'car values-and-bindings))
	)
  )


(defun pp-output (op values-and-bindings)

  (when (>= aam::*trace-level* 1)
    (let ((stream  *standard-output*))
      (if (or (null values-and-bindings) (null (car values-and-bindings)))
	  (format stream "~% *~a failed.*~%" op)
	;;else
	;; If more than one result OR
	;;  result has bindings OR
	;;  result has assumptions.
        (progn
          (pp-results stream values-and-bindings)
          (format stream "~% ~a succeeded.~%" op)))
      )
    )
  )


(defun pp-returned-value (stream val)
  (when (>= aam::*trace-level* 1)
    (format stream "~%  => ~s" val))
  val)

; Pretty print the results of an operation.
;
(defun pp-results (stream values-and-bsets)

  ;; Input is a list of value-and-bsets
  ;; Each element is ((value . bset) ...)

  (terpri stream)

  ;;Filter out NIL bindings
  (setq values-and-bsets
    (nreverse (delete-if #'null values-and-bsets :key #'second)))

  (#-GCL loop #+GCL sloop:sloop
    for result in values-and-bsets
        with n = (length values-and-bsets)
        for i from 1 to n
        do  
        (if (= n 1)
          (format stream "~% Result:")
          (format stream "~% Result (~a of ~a):" i n))
        (pp-binding-set stream (cdr result) T)
       )
  )


; Pretty print a result.
;
(defun pp-binding-set (stream binding-set show-bindings)
  "Result is a binding-set."

  (when (and show-bindings binding-set)
    (format stream "~%   Binding~P: ~VT"
            (length binding-set) *data-column*)
    (dolist (binding-list binding-set)
      (pp-bindings stream binding-list)
      ))

  ;; Handle assumptions, if any
;;  (unless (equal (aresult-label result) '(nil))
;;    (pp-labeled-list stream 2
;;		     (format nil "Assumption~P:"
;;			     (length (aresult-label result)))
;;		       (aresult-label result) t))
  )


; Print out a list of variable bindings.
;
(defun pp-bindings (stream binding-list)
  (dolist (binding binding-list)
    (format stream " ~(~a~) ~VT --- " (car binding) *data-column2*)
    (pp-list stream *data-column2* 80
	     *data-column2* nil (add-names (list (cdr binding))))
    (format stream "~&~VT" *data-column*))
  (format stream "~&~VT" *data-column*)
  )


(defun add-names (frame-list)
  (#-GCL loop #+GCL sloop:sloop
    for f in frame-list
	nconc (frame+name f)))

(defun frame+name (f)
  (if (sfs:kb-frame-p f)
      (let ((n (if (sfs:kb-slot-p 'CL-USER::name)
		   (caar (sfs::kb-get-values f 'CL-USER::name *value)))))
	(cond ((null n) (list f))
	      ((string-equal n f) (list f))
	      (t (list f n))))
      (list f)))



; Print long lists in readable format. 'parens' is true iff the
; list is to be enclosed in parens.
;
(defun pp-list (stream min-col max-col cur-col parens l)

  ;; AF changed ~a to ~s.  (1992?)
  ;; MH: 27 Oct 1997: Output was being lower-cased, which 
  ;;                  caused incorrect output in the case
  ;;                  of quoted atoms like |MILES STANDISH|
  ;;                  Output might not be as pretty, but 
  ;;                  at least it's correct.
  
  ;; (let* ((out-string (format nil "~(~s~)" (if (not (consp l))
  (let* ((out-string (format nil "~s" (cond ((not (consp l)) l)
					    ((null (cdr l))  (car l))
					    (t               l))))
	 (str-len (length out-string))
	 (current cur-col))
    (cond
      ((and parens (< (+ current str-len) max-col))   ; If it fits print it.
       (princ out-string)
       (+ current str-len))

      ((and (consp l) (cdr l))                 ; A list of values
       (cond ((and (> current (/ max-col 2))   ; \n if necessary and useful.
		   (not (eql current min-col)))
	      (format stream "~%~VT" min-col)
	      (setq current min-col)))
       (cond (parens (format stream "(") (setq current (+ 1 current))))
       (let ((out-list l)
	     (l-min-col current))
	 (cond ((and parens (not (consp (car out-list))))	
		;; Special case if first element not a list.
		;; Modified 11/20/89 to only special case if parens.
		(setq current (pp-list stream l-min-col max-col
				       current t (car out-list)))
		(cond ((setq out-list (cdr out-list)) ; If there is more to go.
		       (format stream " ")
		       (setq current (+ 1 current))
		       (setq l-min-col current)))))
         (loop
           (cond
            ((consp out-list)
             (setq current (pp-list stream l-min-col max-col
				    current t (car out-list)))
             (cond ((cdr out-list)        ; Space after every element but last.
                    (format stream " ")
                    (setq current (+ 1 current))))
             (setq out-list (cdr out-list)))
            (out-list                  ; One element remains but it's not nil.
             (setq current (pp-list stream l-min-col max-col
				    current t out-list))
             (return))
            (t
             (return)))))
       (cond (parens (format stream ")") (+ 1 current))
	     (t current))
       )

      (t                                       ; Base case - singleton list
       (when (and (consp l)
		  (consp (car l))
		  (null  (cdar l)))
	 (setq out-string (format nil "~(~s~)" (caar l)))
	 )
       (cond ((not (= current min-col))
	      (format stream "~%~VT" min-col)
	      (setq current min-col)))
       (princ out-string)                          ; Print it.
       (+ current str-len)))))
