;;; -*- Mode:Lisp; Package:SFS; Syntax:COMMON-LISP; Base:10 -*-

(in-package :SFS)

;;;;----------------  ALLIE v3.3  ---------------------------------
;;;
;;; sfs-name.lisp        The AAM's NAME-to-FRAME index mechanism
;;;
;;; 21 Aug 1996   Mike Hewett   copied from v2.0 code (see below)
;;;;-----------------------------------------------------------------  

;;; Copyright (c) 1990-96 by Benjamin J. Kuipers

;;;;----------------  Algernon v2.0  ---------------------------------
;;;
;;; anames.lisp        Algernon's NAME-to-FRAME index mechanism
;;;
;;; 23 Jun 1994   Mike Hewett   copied from v1.3.3 code
;;;                             removed *all-names* global variable
;;;;-----------------------------------------------------------------  

;;; ==== original header =====
;;; Copyright (c) 1990 by James Crawford and Benjamin Kuipers.
;;;  $Id: anames.lisp,v 1.2 1993/06/17 13:39:09 kuipers Exp $

;;;===========================================================================
;;; A frame has two types of names:
;;;
;;;  - A frame has a single true name (tname), which is a symbol referring
;;;    uniquely to that frame.  In the Lisp implementation, the tname is the
;;;    Lisp symbol on whose property list the frame structure is stored.
;;;
;;;  - A frame can have any number of public names (pnames), which are strings.
;;;    These need not be uniquely referring.  They are stored in the name slot
;;;         (:slot name (things :string))

;;; The association from names to objects is stored in a hash-table,
;;; with case-insensitive matching.
;;;
;;; Functions:
;;;    NAMES-RESET        clears name table
;;;    OBJECTS-NAMED      retrieves all objects with the given name
;;;    STORE-NAME         creates an entry for an object
;;;    DELETE-NAME        deletes an entry for an object
;;;    GET-ALL-NAMES      returns a list of dotted pairs of all
;;;                       public names and the true names.
;;;===========================================================================

(defparameter *equalp-test*
    #+GCL #'equal                ;; Fix this when GCL acquires the 'equalp' function.  18 Oct 1996
    #-GCL #'equalp)


(defparameter *public-name-index* (make-hash-table :test *equalp-test*
						   :size 1000))


(defun NAMES-RESET ()
  (clrhash *public-name-index*)
  )


(defun OBJECTS-NAMED (pname)
  "Converts the argument to a string."

  (monitor :RETRIEVE-NAME)
  (gethash (string pname) *public-name-index*)
  )


(defun STORE-NAME (frame pname)
  
  (monitor :STORE-NAME)
  (pushnew frame (gethash (string pname) *public-name-index*))
  )


(defun DELETE-NAME (object pname)
  (setf (gethash (string pname) *public-name-index*)
	(delete object (gethash (string pname) *public-name-index*)))
  )


(defun GET-ALL-NAMES ()
  "Returns an alist containing all public names and the truenames they
map to."

  (let ((names nil))
    (maphash #'(lambda (public-name true-name-list)
		 (dolist (true-name true-name-list)
		   (push (cons public-name true-name) names)
		   )
		 )
	     *public-name-index*)
    names
    )
  )


(defun PUT-ALL-NAMES (collected-names)
  "Argument is an alist of name and value."
  
  (#-GCL loop #+GCL sloop:sloop
	 for (public-name . true-name) in collected-names
	 do  (store-name true-name public-name))
  )
