;;;; -*- Mode:Lisp; Package:CL-USER; Syntax:COMMON-LISP; Base:10 -*-

(in-package :CL-USER)

;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; Copyright (c) 1996 by Micheal Scott Hewett
;;;
;;; This code may be used by anyone for any project, but may not
;;; be sold in source or object form without permission.
;;; If in doubt, follow the GNU "copyleft" guidelines.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; (Contact: hewett@cs.utexas.edu or hewett@cs.stanford.edu)
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;;
;;;  Definitions of packages for the Algernon Abstract Machine
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


;;; Simple Frame System package
(if (find-package :SFS)
  (format t "~%Redefining 'SFS' package.")
  ;;ELSE
  (format t "~%Defining 'SFS' package."))

#-GCL
(defpackage "SFS"
  (:use     "COMMON-LISP")
  (:export  "KB-ALL-CLAUSES"
            "KB-CONTINUATION-P"
            "KB-DECLARE-RULE"
            "KB-DECLARE-CONTINUATION"
            "KB-DEF-FACET"
            "KB-DEF-FRAME"
            "KB-DEF-SLOT"
            "KB-DELETE-FRAME"
            "KB-DELETE-VALUE"
            "KB-DELETE-VALUES"
            "KB-FACET-P"
            "KB-FRAME-P"
            "KB-GET-ALL-FRAMES"
            "KB-GET-SLOT-DOMAINS"
            "KB-GET-VALUES"
            "KB-PRINT"
            "KB-PRINT-FACET"
            "KB-PRINT-FRAME"
	    "KB-PRINT-NO-RULES"
            "KB-PRINT-SLOT"
            "KB-PUT-VALUE"
            "KB-RESET"
	    "KB-RULE-P"
            "KB-SLOT-P"
            "SLOT-FULL-P"
	    "ALL-SLOTS-OF-FRAME"
	    "ALL-FACETS-OF-SLOT"
            
            "DELETE-NAME"
            "GET-ALL-NAMES"
            "NAMES-RESET"
            "OBJECTS-NAMED"
            "STORE-NAME"
            )
  )


#+GCL
(unless (find-package :SFS)
  (make-package "SFS"
		:use      (list (find-package :LISP)))
  )

