;;;; -*- Mode:Lisp; Package:CL-USER; Syntax:COMMON-LISP; Base:10 -*-

(in-package :CL-USER)

;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; Copyright (c) 1996 by Micheal Scott Hewett
;;;
;;; This code may be used by anyone for any project, but may not
;;; be sold in source or object form without permission.
;;; If in doubt, follow the GNU "copyleft" guidelines.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; (Contact: hewett@cs.utexas.edu or hewett@cs.stanford.edu)
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;;
;;;  A file that loads all the SFS files.
;;;
;;; 21 Aug 1996 (mh)  Modified to use the public name module from Algernon.
;;; 22 Aug 1996 (mh)  Added KB-GET-SLOT-DOMAINS
;;; 27 Aug 1996 (mh)  Added ALL-SLOTS-OF-FRAME
;;; 15 Oct 1996 (mh)  Shifted 'join' part of retrieval to the SFS.
;;; 18 Oct 1996 (mh)  Generalized load procedure.
;;; 12 Nov 1996 (mh)  Added unify file.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


(load-algy-file "sfs-package")  ;; Must do this first, else the file won't load correctly.


(defparameter *ALL-SFS-FILES*
    '("sfs-package"
      "sfs-monitor"
      "sfs-name"
      "sfs-unify"
      "sfs"
      "sfs-version"))


(defun load-or-compile-sfs ()

  (if (check-file-mod-times *ALL-SFS-FILES*)
      (progn
	(format *trace-output* "~2%Some SFS source files have been updated.")
	(format *trace-output* "~%Compiling and loading SFS...")
	(compile-sfs))
    ;;else
    (progn
      (format *trace-output* "~2%Loading SFS...")
      (load-sfs)
      )
    )
  )



(defun compile-sfs ()

  (when (fboundp 'SFS::kb-reset)
    (sfs::kb-reset))


  (dolist (filename *ALL-SFS-FILES*)
    (load-algy-source-file filename))

  ;; Compile SFS

  (dolist (filename *ALL-SFS-FILES*)
    (compile-algy-file filename))

  (load-sfs)
  )


;;; LOAD-SFS


(defun load-sfs ()

  (when (fboundp 'SFS::KB-RESET)
    (sfs::kb-reset))

  (dolist (filename (cdr *ALL-SFS-FILES*))  ;; already loaded package
    (load-algy-file filename))
  )

