;;;; -*- Mode:Lisp; Package:CL-USER; Syntax:COMMON-LISP; Base:10 -*-

(in-package :SFS)

;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; Copyright (c) 1996 by Micheal Scott Hewett
;;;
;;; This code may be used by anyone for any project, but may not
;;; be sold in source or object form without permission.
;;; If in doubt, follow the GNU "copyleft" guidelines.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; (Contact: hewett@cs.utexas.edu or hewett@cs.stanford.edu)
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;;
;;;  A unifier for the SFS.
;;;
;;; 12 Nov 1996 (mh)  Copied the AAM unify function.
;;;                   Need to copy it for package independence.
;;;    
;;; 29 Oct 1997 (nm)  Replaced UNIFY by INSTANCE-P, one-way
;;;                   pattern matching.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; (INSTANCE-P EXPRESSION PATTERN)
;;;    => T or NIL
;;; side-effects: *pat-env*.  INSTANCE-P is similar to ALGY-UNIFY except 
;;; that variables in EXP are treated as constants.
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

(defparameter *pat-env* (list :pat))

(defmacro my-variable-p (x)
  `(and (symbolp ,x) (char= #\? (char (symbol-name ,x) 0))))

(defun instance-p (exp pat)
  "Determines whether EXP is an instance of PAT, returning T or NIL.
*PAT-ENV* may be destructively changed.  This function is similar 
to ALGY-UNIFY except that variables in EXP are treated as constants."
  (labels ((instance-internal (exp pat)
	     (cond ((my-variable-p pat)
		    (let ((binding (assoc pat (cdr *pat-env*))))
		      (if binding
			  (equalp (cdr binding) exp)
			(progn (push (cons pat exp) (cdr *pat-env*))
			       t)) ))
		   ((consp pat)
		    (if (consp exp)
			(do ((pat-list pat (cdr pat-list))
			     (exp-list exp (cdr exp-list)))
			    ((or (null pat-list) 
				 (null exp-list))
			     (and (null pat-list) 
				  (null exp-list)) )
			  (unless (instance-internal (car exp-list) 
						     (car pat-list))
			    (return nil)) )
		      nil))
		   ((consp exp) nil)
		   ((equalp pat exp) t)) ))

    (monitor :SELECT)

    (setf (cdr *pat-env*) nil)
    (instance-internal exp pat) ))



