;;; Test forms for the Algernon Abstract Machine
;;;
;;; Mike Hewett  8 May 1996
;;; Mike Hewett  4 Aug 1996  Version 2, with rules.
;;; Mike Hewett 12 Aug 1996  Modified to work with Algernon (for comparison)
;;; 

(in-package :CL-USER)


(defun test-algy-2 ()

  (acom-reset)           ;;(sfs:kb-reset)
                         ;;(load "aam-init")

  (init-test-kb)    ;; This should do everything, using the rules.

  (print-people)
  )


(defun init-test-kb ()

  (tell '((:taxonomy (things
		      (people Arnold Ana Andre Adriana
			      Bob Betty Bill Barbara
			      Cassius Carla Charles Cassandra Chi)))

	  (:slot father      (people people))
          (:slot mother      (people people))
          (:slot sister      (people people))
          (:slot brother     (people people))
          (:slot parent      (people people))
          (:slot child       (people people))
          (:slot aunt        (people people))
          (:slot uncle       (people people))
          (:slot great-aunt  (people people))
          (:slot sibling     (people people))
          (:slot cousin      (people people))))


  (tell '((inverse child    parent)
          (inverse sibling  sibling)
          (inverse cousin   cousin)))


  ;; RULES - A mother or father is a parent.
  (tell '((:rules people 
                  ((mother ?a ?mom) -> (parent ?a ?mom))
                  ((father ?a ?dad) -> (parent ?a ?dad))

  ;; A sister or brother is a sibling
                  ((sister  ?a ?sis) -> (sibling ?a ?sis))
                  ((brother ?a ?bro) -> (sibling ?a ?bro))

  ;; The child of a sibling of a parent is a cousin.
                  ((parent  ?a      ?parent)
                   (sibling ?parent ?sib)
                   (child   ?sib    ?b)
                   ->
                   (cousin ?a ?b))

  ;; The parent of your sibling is also your parent.
                  ((sibling  ?a ?b)
                   (parent   ?a ?parent)
                   ->
                   (parent   ?b ?parent))

  ;; The aunt of your parent is your great-aunt.
                  ((parent ?person ?parent)
                   (aunt   ?parent ?aunt)
                   ->
                   (great-aunt ?person ?aunt))

  ;; The sister of your parent is your aunt, and similar for uncle.
                  ((parent ?person ?parent)
                   (sister ?parent ?aunt) 
                   ->
                   (aunt ?person ?aunt))

                  ((parent ?person ?parent)
                   (brother ?parent ?uncle) 
                   ->
                   (uncle ?person ?uncle)))))



  ;;; Here are the actual family relationships.

  (tell '((father  Arnold      Bob)     ;;Rule will fill in parent relation
          (mother  Arnold      Betty)   ;;Rule will fill in parent relation
          (sister  Arnold      Ana)))   ;;Rules: sibling, brother, parent (for Ana)

  (tell '((father  Bob         Cassius)
          (mother  Bob         Carla)
          (brother Bob         Bill)))

  (tell '((father  Adriana     Bill)
          (mother  Andre       Barbara)
          (sister  Andre       Adriana)))

  (tell '((father Betty Charles)
          (mother Betty Cassandra)
          (sister Cassandra Chi)))

  )



(defun print-people ()

  (tell '((:show Arnold)
          (:show Ana)
          (:show Andre)
          (:show Adriana)
          
          (:show Bob)
          (:show Betty)
          (:show Bill)
          (:show Barbara)
          
          (:show Cassius)
          (:show Carla)
          (:show Charles)
          (:show Cassandra)
          (:show Chi)
          ))
  )
