;;; Test forms for the Algernon Abstract Machine
;;;
;;; Mike Hewett  8 May 1996


(in-package :CL-USER)


(defun test-aam ()

  (acom-reset)

  (init-test-kb)

  (time
   (progn 
     (aam-test-1)
     (aam-test-2)
     (aam-test-3)
     (aam-test-4)
     (aam-test-5)
     (aam-test-6)
     (aam-test-7)
     )
   )
  )


(defun test-aam-rules ()

  (acom-reset)

  (init-test-kb)

  (aam-test-8)
  (aam-test-9)
  (aam-test-10)
  )


(defun test-aam-rules-2 ()

  (acom-reset)

  (init-test-kb)

  (aam-test-11)
  )


(defun init-test-kb ()

  (tell '((:taxonomy   (things
			(people  John Mary Mr-Smith Mrs-Smith
				 GF-Smith GM-Smith GF-Jones GM-Jones
				 Mildred-Jordan)))

	  (:SLOT father      (people people))
	  (:SLOT mother      (people people))
	  (:SLOT sister      (people people))
	  (:SLOT brother     (people people))
	  (:SLOT parent      (people people))
	  (:SLOT aunt        (people people))
	  (:SLOT great-aunt  (people people))

	  (mother John Mrs-Smith)
	  (father Mary Mr-Smith)

	  (father Mr-Smith  GF-Smith)
	  (mother Mr-Smith  GM-Smith)
	  (father Mrs-Smith GM-Jones)

	  (parent Mary Mr-Smith)
	  (parent Mrs-Smith GF-Jones)
	  (parent Mrs-Smith GM-Jones)

	  (parent John Mr-Smith)
	  (parent Mr-Smith GF-Smith)

	  ;; These are inferred later

;;	  (father John Mr-Smith)
;;	  (mother Mary Mrs-Smith)
;;	  (mother Mr-Smith  GM-Smith)
;;	  (mother Mrs-Smith GM-Jones)
;;	  (parent Mary      Mrs-Smith)
	  )
	)
  )



(defun test-header (number description)
  (format t "~2%--------------------------------------------")
  (format t "~%(~D)  ~A" number description)
  (format t "~%--------------------------------------------")
  )  


(defun aam-test-1 ()
  "Tests a single ground clause."

  (test-header 1 "Testing ground clauses.")
  
  (tell    '((mother Mary Mrs-Smith)
             (parent Mary Mrs-Smith)
             (mother Mrs-Smith GM-Jones)))
  (ask     '((mother Mrs-Smith ?who)))
  (ask     '((mother Mrs-Smith GM-Jones)))   ;; Verify
  )


(defun aam-test-2 ()
  "Tests a ground path."

  (test-header 2 "Testing ground paths.")
  
  (tell '((father John     Mr-Smith)
	  (mother Mr-Smith GM-Smith)))
  )


(defun aam-test-3 ()
  "Tests path with binding list."

  (test-header 3 "Testing non-ground paths.")
  
  (tell '((father John ?dad)
	  (father ?dad ?grandpa)
	  (:eval (format t "~%John's paternal grandfather is ~A" '?grandpa)))
	)
  )


(defun aam-test-4 ()
  "Tests branching."

  (test-header 4 "Testing branching.")
  
  (ask '((parent Mary ?parent)
	 (parent ?parent ?g-parent)
	 (:eval (format t "~%Mary's grandparent is ~A." '?g-parent)))
       )
  )


(defun aam-test-5 ()
  "Tests branching without failure."

  (test-header 5 "Testing branching with partial failure.")
  
  (ask '((parent Mary ?parent)
	 (parent John ?parent2)
	 (parent ?parent ?g-parent)
	 (parent ?parent2 ?g-parent)
	 (:eval (format t "~%John and Mary's common grandparent is ~A."
		          '?g-parent))
	 ))
  )


(defun aam-test-6 ()
  "Tests branching with total failure."

  (test-header 6 "Testing branching with total failure.")
  
  (ask '((mother Mary ?parent)
	 (father John ?parent2)
	 (parent ?parent ?g-parent)
	 (parent ?parent2 ?g-parent)
	 (:eval (format t "~%Hey! John and Mary's parents are siblings!"))
	 ))
  )


(defun aam-test-7 ()
  "Tests negated slots."
  
  (test-header 7 "Testing negated slots.")

  (tell '((:SLOT younger  (people people))))

  (tell '((younger John Mary)            ;; John is younger than Mary
	  (not (younger Mary John))
	  (not (parent  Mary John))
	  (not (parent  John Mary))
	  ))

  (tell '((:SHOW John)
	  (:SHOW Mary)))


  (tell '((younger Mrs-Smith Mr-Smith)))

  (ask  '((parent Mary ?p1)
	  (parent Mary ?p2)
	  (:NEQ ?p1 ?p2)
	  (younger ?p1 ?p2)
	  (:eval (format t "~%~A is the younger of Mary's parents."
		  '?p1))
	  ))
  )


(defun aam-test-8 ()
  "Tests if-added rule activation"

  (test-header 8 "Testing if-added rule activation.")
  
  (tell    '((mother Mary Mrs-Smith)
             (parent Mary Mrs-Smith)
	     (:RULES PEOPLE
	        ((mother ?a ?mom) -> (parent ?a ?mom)))

	     (mother Mrs-Smith GM-Jones)))

  (ask  '((parent Mrs-Smith ?parent)))
  )



(defun aam-test-9 ()
  "Tests if-needed rule activation"

  (test-header 9 "Testing if-needed rule activation.")

  (tell '((:A (?x PEOPLE) (name ?x "Mary-Jones"))
	  (sister Mrs-Smith ?x)

	  (:RULES PEOPLE
	   ((aunt ?person ?aunt)
	    <- 
	    (parent ?person ?parent)
	    (sister ?parent ?aunt)))))

  (ask  '((aunt Mary ?aunt)))
  )


(defun aam-test-10 ()
  "Tests continuation activation"

  (test-header 10 "Testing continuation activation.")

  (tell '((:A (?x PEOPLE) (name ?x "Sarah-Jones"))
	  (sister Mrs-Smith Sarah-Jones)))
  
  (ask  '((aunt Mary ?aunt)))
  )


(defun aam-test-11 ()
  "Tests forward-backward combination."

  (test-header 11 "Testing forward-backward combination activation.")

  (tell '((:RULES PEOPLE
		  ((parent ?person ?parent)
		   (aunt   ?parent ?aunt)
		   ->
		   (great-aunt ?person ?aunt))

		  ((aunt ?person ?aunt)
		   <- 
		   (parent ?person ?parent)
		   (sister ?parent ?aunt))

		  ((mother ?a ?mom) -> (parent ?a ?mom)))

	  (mother Mary Mrs-Smith)
	  (mother Mrs-Smith GM-Jones)
	  ))


  (tell '((sister GM-Jones Mildred-Jordan)))
  )

