// ===================================================================
// Copyright (c) 1997, All rights reserved, by Micheal Hewett
//
// This software is free for educational and non-profit use.
// Any for-profit use must be governed by a license available
// from the author, who can be contacted via email at 
// "hewett@cs.stanford.edu"
//
// ===================================================================
//
//  AmazeConnection.java  - A Connection class for Amaze
//
//  17 Feb 1997
//
// -------------------------------------------------------------------

package amaze;

import java.io.*;
import java.net.*;

import amaze.algy.*;
import lib.dynatype.*;   // For LispParser
import lib.net.*;        // For Connection


/**
 * AmazeConnection maintains a connection to/from
 * LISP.  It overrides the default behavior of
 * Connection only to process the input received
 * from LISP.
 * 
 * @see lib.display.Connection
 * @see Amaze
 * @author  Micheal S. Hewett    hewett@cs.utexas.edu
 * @date    Mon Feb 17 15:49:36 1997
 * @version 1.0
 *
 */
public class AmazeConnection extends Connection
{
  /**
   * The parser used to read data from the stream.
   * 
   * @see lib.dynatype.LispParser
   * @author  Micheal S. Hewett    hewett@cs.utexas.edu
   * @date    Fri Feb 21 10:17:25 1997
   * @version 1.0
   * 
   */
  public static LispParser PARSER = null;
  

  /**
   * Send in the Socket over which the data will flow.
   * 
   * @see lib.net.Connection
   * @param Socket clientSocket
   * @author  Micheal S. Hewett    hewett@cs.utexas.edu
   * @date    Mon Feb 17 15:49:36 1997
   * @version 1.0
   * 
   */
  public AmazeConnection(Socket clientSocket)
  {
    super(clientSocket);

    PARSER = new LispParser(fromExternal);
  }


  /**
   * Overrides the default behavior of Connection.run()
   * to do nothing.  This class does explicit send/receive
   * and is not in a send/receive loop.
   *
   * @param String line  
   * @return void
   * @author  Micheal S. Hewett    hewett@cs.utexas.edu
   * @date    Mon Feb 17 15:51:44 1997
   * @version 1.0
   * 
   */
  public void run()
  {
    while (true)
    {
      // If the external program sends us anything, shut down.
      try { if (System.in.available() > 0)
	    {
	      System.err.println("\n;; Amaze: I'm shutting down."); System.err.flush();
	      System.exit(0);
	    }
            else
	     sleep(250);
          }
      catch (IOException e)
      {
	System.err.println(";; AmazeConnection.run() caught an IO Exception..." + e + "\n");
	stop();
      }
      catch (InterruptedException e)
      {
	System.err.println(";; AmazeConnection.run() caught an InterruptedException..." + e + "\n");
	stop();
      }
      catch (RuntimeException e)
      {
	System.err.println(";; AmazeConnection.run() caught a Runtime Exception..." + e + "\n");
      }
    }
  }

  /**
   * Uses a LISP reader to read an input value,
   * then returns it to the caller.
   * 
   * @see lib.dynatype.LispValue
   * @see lib.dynatype.LispParser
   * @return LispValue the value read.
   * @author  Micheal S. Hewett    hewett@cs.utexas.edu
   * @date    Fri Feb 21 10:15:13 1997
   * @version 1.0
   * 
   */
  public LispValue receive()
  {
    LispValue value = LispValue.NIL;

    try { value = PARSER.parse(); }
    catch (EOFException e)
      { System.err.println("AmazeConnection received incomplete input from LISP.  Returning NIL.");
        value = LispValue.NIL;
      }

    return value;
  }

}


