// SpecTcl generated class AmazePanel, version 0.01

package amaze;

import java.awt.*;

import amaze.browser.*;
import amaze.algy.KBManager;

import lib.dynatype.*;   // For the LispValue class.
import lib.net.*;        // For the Connection class.


public class AmazePanel extends Panel
{		
  Label     label_2;
  TextField frameNameField;
  Button    viewFrameButton;
  Button    viewRuleCodeButton;

  AlgyBrowser browser_1;
  
  Label     label_4;
  Label     label_5;
  Label     label_1;
  public TextArea  lispOutputArea;
  public LispInput lispInputArea;

  Connection toLisp;


  //methods to support form introspection
  public static String names[] = {
    "label_2","frameNameField","viewFrameButton",
    "viewRuleCodeButton",
    "label_4","label_5",
    "lispOutputArea","label_1","lispInputArea",
  };
  public String[] getNames() {
    return names;
  }

  //There should be an easier way to do this
  public Object[] getWidgets() {
    int i = 0;
    
    Object[] list = new Object[9];
    list[i++] = label_2;
    list[i++] = frameNameField;
    list[i++] = viewFrameButton;
    list[i++] = viewRuleCodeButton;
    list[i++] = label_4;
    list[i++] = label_5;
    list[i++] = lispOutputArea;
    list[i++] = label_1;
    list[i++] = lispInputArea;
    return list;
  }

  public AmazePanel()
  {
    super();

    init();
  }

  public void setConnection(Connection conn)
  {
    toLisp = conn;
  }


  public void init() {

    // main panel
    GridBagLayout grid = new GridBagLayout();
//    int rowHeights[] = {0,30,30,30,30,30,30,30,30,30,30,30,30,30,11,30,30,30,30,30,30,30};
    int rowHeights[] = {0,30,30,30,30,30,30,30,30,30,30,30,30,30,11,30};
//    int columnWidths[] = {0,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30};
    int columnWidths[] = {0,15,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30};
//    double rowWeights[] = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
    double rowWeights[] = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0};
//    double columnWeights[] = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
    double columnWeights[] = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
    grid.rowHeights = rowHeights;
    grid.columnWidths = columnWidths;
    grid.rowWeights = rowWeights;
    grid.columnWeights = columnWeights;

    label_2 = new Label();
    label_2.setText("Frame:");
    label_2.setFont(new Font("Helvetica",Font.PLAIN + Font.BOLD , 12));
    label_2.setAlignment(Label.RIGHT);
    this.add(label_2);

    frameNameField = new TextField(40);
    this.add(frameNameField);

    viewFrameButton = new Button();
    viewFrameButton.setLabel("Show Frame");
    this.add(viewFrameButton);

    viewRuleCodeButton = new Button();
    viewRuleCodeButton.setLabel("Show Rule Code");
    this.add(viewRuleCodeButton);

    label_4 = new Label();
    label_4.setFont(new Font("Helvetica",Font.PLAIN + Font.BOLD , 12));
    label_4.setText("Lisp Trace:");
    this.add(label_4);

    label_5 = new Label();
    this.add(label_5);

    lispOutputArea = new TextArea(1,1);
    lispOutputArea.setEditable(false);
    this.add(lispOutputArea);

    label_1 = new Label();
    label_1.setText("LISP input:");
    label_1.setFont(new Font("Helvetica",Font.PLAIN + Font.BOLD , 12));
    label_1.setAlignment(Label.RIGHT);
    this.add(label_1);

    lispInputArea = new LispInput(70);
    this.add(lispInputArea);

    browser_1 = new AlgyBrowser(Amaze.KB_MGR, 3, Amaze.DISPLAY);
//    browser_1.init();
    this.add(browser_1);

//    browser_2 = new AlgyBrowser();
//    browser_2.init();
//    this.add(browser_2);



    // Geometry management
    GridBagConstraints con = new GridBagConstraints();
    reset(con);
    con.gridx = 1;
    con.gridy = 1;
    con.gridwidth = 2;
    con.anchor = GridBagConstraints.CENTER;
    con.fill = GridBagConstraints.BOTH;
    grid.setConstraints(label_2, con);

    reset(con);
    con.gridx = 3;
    con.gridy = 1;
    con.gridwidth = 16;
    con.anchor = GridBagConstraints.CENTER;
    con.fill = GridBagConstraints.BOTH;
    grid.setConstraints(frameNameField, con);

    reset(con);
    con.gridx = 20;
    con.gridy = 1;
    con.gridwidth = 3;
    con.anchor = GridBagConstraints.CENTER;
    con.fill = GridBagConstraints.BOTH;
    grid.setConstraints(viewFrameButton, con);

    reset(con);
    con.gridx = 24;
    con.gridy = 1;
    con.gridwidth = 3;
    con.anchor = GridBagConstraints.CENTER;
    con.fill = GridBagConstraints.BOTH;
    grid.setConstraints(viewRuleCodeButton, con);

    reset(con);
    //    con.gridx = 1;
    con.gridx = 2;
    con.gridy = 2;
    //    con.gridwidth = 34;
    con.gridwidth = 28;
    con.gridheight = 6;
    con.anchor = GridBagConstraints.CENTER;
    con.fill = GridBagConstraints.BOTH;
    grid.setConstraints(browser_1, con);

    reset(con);
//    con.gridx = 1;
    con.gridx = 2;
//    con.gridy = 14;
    con.gridy = 8;
    con.gridwidth = 3;
    con.anchor = GridBagConstraints.CENTER;
    con.fill = GridBagConstraints.BOTH;
    grid.setConstraints(label_4, con);

    reset(con);
//    con.gridx = 4;
    con.gridx = 5;
//    con.gridy = 14;
    con.gridy = 8;
    con.gridwidth = 25;
    con.anchor = GridBagConstraints.CENTER;
    con.fill = GridBagConstraints.BOTH;
    grid.setConstraints(label_5, con);

    reset(con);
//    con.gridx = 1;
    con.gridx = 2;
//    con.gridy = 15;
    con.gridy = 9;
    con.gridwidth = 28;
    con.gridheight = 6;
    con.anchor = GridBagConstraints.CENTER;
    con.fill = GridBagConstraints.BOTH;
    grid.setConstraints(lispOutputArea, con);

    reset(con);
    con.gridx = 1;
//    con.gridy = 21;
    con.gridy = 15;
    con.gridwidth = 3;
    con.anchor = GridBagConstraints.EAST;
    con.fill = GridBagConstraints.BOTH;
    grid.setConstraints(label_1, con);

    reset(con);
    con.gridx = 4;
//    con.gridy = 21;
    con.gridy = 15;
    con.gridwidth = 24;
    con.anchor = GridBagConstraints.CENTER;
    con.fill = GridBagConstraints.BOTH;
    grid.setConstraints(lispInputArea, con);

//    reset(con);
//    con.gridx = 1;
//    con.gridy = 8;
//    con.gridwidth = 34;
//    con.gridheight = 6;
//    con.anchor = GridBagConstraints.CENTER;
//    con.fill = GridBagConstraints.BOTH;
//    grid.setConstraints(browser_2, con);


    // Resize behavior management and parent heirarchy
    setLayout(grid);
  }

  public boolean handleEvent(Event event) {
    if (event.id==Event.KEY_ACTION && event.key==event.F4
	&& event.modifiers==event.ALT_MASK) {  // Alt-F4 always exits
      System.err.println("\nAlt-F4 received.");
      System.exit(3);
    } 
    else if (((event.id == event.ACTION_EVENT) && (event.target == viewFrameButton)) // View Frame
	     || 
	     ((event.id == event.KEY_RELEASE)      // View Frame
	      && (event.target == frameNameField)
	      && event.key==10))                   // Standard Java value for CR
    {
      Amaze.viewFrame(frameNameField.getText());
      frameNameField.selectAll();
    }
    else if ((event.id == Event.ACTION_EVENT) && (event.target == viewRuleCodeButton)) // View Rule
    {
      Amaze.viewRuleCode(frameNameField.getText());
      frameNameField.selectAll();
    }
    
    else
      return super.handleEvent(event);
    return true;
  }


  private void reset(GridBagConstraints con) {
    con.gridx = GridBagConstraints.RELATIVE;
    con.gridy = GridBagConstraints.RELATIVE;
    con.gridwidth = 1;
    con.gridheight = 1;
 
    con.weightx = 0;
    con.weighty = 0;
    con.anchor = GridBagConstraints.CENTER;
    con.fill = GridBagConstraints.NONE;
 
    con.insets = new Insets(0, 0, 0, 0);
    con.ipadx = 0;
    con.ipady = 0;
  }

}

