// ===================================================================
// Copyright (c) 1997, All rights reserved, by Micheal Hewett
//
// This software is free for educational and non-profit use.
// Any for-profit use must be governed by a license available
// from the author, who can be contacted via email at 
// "hewett@cs.stanford.edu"
//
// ===================================================================
//
//  AlgyRule.java  - A Frame class to represent Algernon rules.
//
//  20 Feb 1997
//
// -------------------------------------------------------------------

package amaze.algy;

import java.io.*;

import lib.dynatype.*;

/**
 * An AlgyRule is a symbol that represents a rule in
 * the Algernon world.  The differentiation is needed
 * to distinguish between regular symbols and those
 * that represent frames, slots and rules.
 *
 * @see lib.dynatype.LispSymbol
 * @see AlgyFrame
 * @see AlgySlot
 * @author  Micheal S. Hewett    hewett@cs.utexas.edu
 * @date    Thu Feb 20 15:17:39 1997
 * @version 1.0
 *
 */
public class AlgyRule extends AlgyFrame
{
  /**
   * Send in a String or LispString and get back an AlgyRule
   * This method does <b>not</b> intern the symbol.
   * @see lib.dynatype.LispSymbol#LispSymbol
   * @author  Micheal S. Hewett    hewett@cs.utexas.edu
   * @date    Thu Feb 20 15:17:39 1997
   * @version 1.0
   * 
   */
  public AlgyRule(String ruleName)
  {
    super(ruleName);
  }

  public AlgyRule(LispString ruleNameString)
  {
    super(ruleNameString);
  }


  // Do Algyrules have any different behavior than symbols?

}

