// ===================================================================
// Copyright (c) 1997, All rights reserved, by Micheal Hewett
//
// This software is free for educational and non-profit use.
// Any for-profit use must be governed by a license available
// from the author, who can be contacted via email at 
// "hewett@cs.stanford.edu"
//
// ===================================================================
//
//  KBManagerNoConnection.java  - Exceptions generated by the KBManager
//
//  20 Feb 1997
//
// -------------------------------------------------------------------

package amaze.algy;

import java.io.*;


/**
 * KBManagerNoConnection is raised when the KBManager 
 * connection to the external KB is raised.
 *
 * @see java.lang.RuntimeException
 * @see KBManagerException
 * @see KBManagerInvalidFrame
 * @see	KBManagerInvalidSlot 
 * @see	KBManagerInvalidFacet
 * @author  Micheal S. Hewett    hewett@cs.utexas.edu
 * @date    Thu Feb 20 16:32:31 1997
 * @version 1.0
 *
 */
public class KBManagerNoConnection extends KBManagerException
{
  /**
   * Send in a string or nothing.  The constructor does
   * nothing except call its superior constructor.
   * @see KBManagerException
   * @author  Micheal S. Hewett    hewett@cs.utexas.edu
   * @date    Thu Feb 20 16:32:31 1997
   * @version 1.0
   * 
   */
  public KBManagerNoConnection()         { super();  }
  public KBManagerNoConnection(String s) { super(s); }
}

