(in-package :cl-user)


(defun special-p (x)
  (and (keywordp x)
       (member x '(:slot :rule :frame))))

(defun newx (typ x)
  (let ((prefix  (case typ (:SLOT  "S-") (:RULE "R-") (:FRAME "F-"))))
    (intern (concatenate 'string prefix (symbol-name x) ) :keyword)))


;; any sequence of symbols (... :slot XXX ...)
;; becomes (... :F-XXX ...)

(defun filter (l)
  (cond ((atom l)   l)
	((consp l)
	 (if (special-p (car l))
	     (cons (newx (first l) (second l))
		   (filter (cddr l)))
	   ;;else
	   (cons (filter (car l)) (filter (cdr l)))
	   ))))
