/*****************************************************************************
 **                           Class AlgyBrowser                             **
 *****************************************************************************/
//    File: AlgyBrowser.java
// Descrip: See javadoc comments above the AlgyBrowser class declaration.
//
// History: Wed Feb 19 16:41:14 1997 created by Spencer Bishop
// $Id$
/*****************************************************************************/

package amaze.browser;

import java.awt.*;
import amaze.algy.KBManager;

/**
 * AlgyBrowser provides an interface for the user to browse the graph defined
 * by a specific relation in an Algernon KB.  The user begins by specifying
 * a frame to begin from (the root) and a relation s/he is interested in.
 * For example,
 * <pre>
 *  -------------------------------------------------------------------
 * |            --------  |                    |            |          |
 * |      Root:| Things | | *Physical-Objects* | Tools      | Females  |
 * |            --------  | Things             | Cars       | Males    |
 * |  Relation:| Subset | | Slots              | *People*   |          |
 * |            --------  | Objects            | Buildings  |          |
 * |  (*) Value           | ...                | ...        |          |
 * |  ( ) Non-Value       |                    |            |          |
 * |                      |                    |            |          |
 *  ---------------------- -------------------- ------------ ----------
 * |            --------  |                    |            |          |
 * |      Root:| Opus   | | Milo               | Opus       | Binkly   |
 * |            --------  | *Steve-Dallas*     | *Milo*     | Opus     |
 * |  Relation:| Friend | | Bill-the-Cat       |            | Steve-Dal|
 * |            --------  | Binkly             |            | ...      |
 * |  (*) Value           | ...                |            |          |
 * |  ( ) Non-Value       |                    |            |          |
 * |                      |                    |            |          |
 *  ---------------------- -------------------- ------------ ----------
 * </pre>
 * The contents of the display is driven by the user's choices.  For example,
 * in the top row of the AlgyBrowser display, the list "Tools, Cars, etc."
 * was displayed when the user clicked the left mouse button on 
 * Physical-Objects in the previous box.  For a more detailed explanation
 * of the functionality the AlgyBrowser provides from the point of few
 * of the application user, see the 
 * <a href="http://www.cs.utexas.edu/users/qr/algy/amaze-ug.html">
 * Amaze user's guide</a>.
 * <p>
 * 
 * From the programmer's point of view, AlgyBrowser accesses Algernon through
 * the class <a href="amaze.KBManager.html">KBManager</a>.  KBManager returns
 * lists of values defined in the package 
 * <a href="lib.dynatype.html">lib.dynatype</a>.
 */
public class AlgyBrowser extends Panel
{
   private static int NUM_LEVELS_PER_BROWSER = 4;

   private int num_rows;        // Number of BrowserRows
   private BrowserRow rows[];   // Actual BrowserRows

   public AlgyBrowser(KBManager kb, int num_rows, Frame parent)
   {
      this.num_rows = num_rows;
      rows = new BrowserRow[num_rows];
      /* HACK - for some reason the vertical gap specification in the
       *   creation of the GridLayout isn't putting a gap above the 
       *   first component added (java API docs says it's supposed to.)
       *   Introducing canvas 0 height to alleviate the problem.
       */
      setLayout(new BorderLayout(0, 20));
      Canvas c = new Canvas();
      c.resize(0,0);
      add("North", c);
      Panel p = new Panel();
      p.setLayout(new GridLayout(num_rows, 1, 0, 15));
      for (int i = 0; i < num_rows; ++i)
      {
         rows[i] = new BrowserRow(kb, NUM_LEVELS_PER_BROWSER, parent);
         p.add(rows[i]);
      }
      add("Center", p);
   }
}

