/*****************************************************************************
 **                            Class BrowserRow                             **
 *****************************************************************************/
//    File: BrowserRow.java
// Descrip: See javadoc comments above the BrowserRow class declaration.
//
// History: Thu Feb 20 19:04:34 1997 created by Spencer Bishop
//                                   used SpecTcl to generate UI layout
// $Id$
/*****************************************************************************/

package amaze.browser;

import java.awt.*;
import java.util.*;

import amaze.Amaze;
import amaze.algy.*;
import lib.dynatype.*;
import lib.display.*;

/**
 * Implements the UI of a single row in an AlgyBrowser object. Looking
 * at the description of AlgyBrowser should make clear what it is objects
 * of this class need to support.
 * @see AlgyBrowser
 */
class BrowserRow extends Panel
{
   // BrowserRow state data (Stuff other than UI elements)
   // BrowserTree being manipulated and displayed 
   private BrowserTree tree; 
   // Number of levels in tree that can be displayed simultaneously,
   // ie., w/o scrolling.
   private int num_levels;
   // Least level number of the levels in tree that are actually being
   // (levels with lesser level numbers have been hidden by scrolling)
   // Whenever set to value of -1, it means nothing is displayed at all.
   private int display_start_level;
   // Reference to KBManager to translate public names to AlgyFrames
   private KBManager kb;
   // Time of last update, info used by higher level GUI to decide
   // among a collection of BrowserRows which one was LRU.
   private long time_of_last_update;

   // Interface elements
   private List lboxes[];     // Array of listboxes displaying BrowserTree
   // Field where name of root frame of tree is entered
   private TextField root_field;
   // Field where name of slot tree branches on is entered
   private TextField slot_field;
   // Checkbox indicating user wants the values facet
   private ActiveCheckbox values;
   // Checkbox indicating user want the non-values facet
   private ActiveCheckbox non_values;
   // Activation indicates user wants to clear the displayed tree and
   // start at the frame and relation entered in the root and slot fields.
   private ActiveButton apply;
   // Activation means to scroll tree to unhide most recently hidden level
   // near the root.
   private ActiveButton left;
   // Activation means opposite of activating left
   private ActiveButton right;
   // A sub-panel in the display needed for extracting position
   // and size info during paint()
   private Panel frame_1;

   // Dialog box used to display error messages
   private static MsgDialog error_dialog;
   // Parent frame of Dialog box
   private static Frame error_dialog_parent;
   
   public BrowserRow (KBManager kb, int num_levels, Frame parent)
   {
      // Right now the number of levels that are displayed is hard-wired,
      // so print a warning message and proceed with hard-wired value
      if (num_levels != 4)
      {
         System.err.println(
            "ERROR in " + this.getClass().getName() + 
            "::BrowserRow() - Variable number of displayed levels not implemented, using hard-wired value of 4.");
         num_levels = 4;
      }

      // Init static vars
      error_dialog_parent = parent;

      // Init state variables
      tree = new BrowserTree();
      tree.setKBManager(kb);
      this.num_levels = num_levels;
      lboxes = new List[num_levels];
      display_start_level = -1;
      this.kb = kb;
      time_of_last_update = 0;

      // Init UI elements
      /* *********** BEGIN SpecJava Generated Code **********
       * Note - although this code is generated by SpecJava it
       *  it has been customized slightly.  For example, I replaced
       *  calls to Button() with calls to ActiveButton().
       */
      Panel frame_3;
      Panel frame_1;
      Label label_1;
      Button button_3;
      Checkbox radiobutton_3;
      CheckboxGroup default_group = new CheckboxGroup();
      Checkbox radiobutton_4;
      Button button_2;
      TextField entry_1;
      List listbox_1;
      List listbox_2;
      List listbox_3;
      List listbox_4;
      Label label_2;
      TextField entry_2;
      Button button_4;

      // SpecJava generated code
      // main panel
      GridBagLayout grid = new GridBagLayout();
      int rowHeights[] = {0,30,30,30,30};
      int columnWidths[] = {0,30,30,21,30,30,30,30,30,21,30,30,30,30,30,21,30,30,30,30,30,21,30,30,30,30,30,21};
      double rowWeights[] = {0.0,0.0,0.0,0.0,0.0};
      double columnWeights[] = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
      grid.rowHeights = rowHeights;
      grid.columnWidths = columnWidths;
      grid.rowWeights = rowWeights;
      grid.columnWeights = columnWeights;

      // container frame_3 in this.
      GridBagLayout frame_3_grid = new GridBagLayout();
      int frame_3_rowHeights[] = {0,30};
      int frame_3_columnWidths[] = {0,30,30};
      double frame_3_rowWeights[] = {0.0,0.0};
      double frame_3_columnWeights[] = {0.0,0.0,0.0};
      frame_3_grid.rowHeights = frame_3_rowHeights;
      frame_3_grid.columnWidths = frame_3_columnWidths;
      frame_3_grid.rowWeights = frame_3_rowWeights;
      frame_3_grid.columnWeights = frame_3_columnWeights;

      // container frame_1 in this.
      GridBagLayout frame_1_grid = new GridBagLayout();
      int frame_1_rowHeights[] = {0,30};
      int frame_1_columnWidths[] = {0,30,30};
      double frame_1_rowWeights[] = {0.0,0.0};
      double frame_1_columnWeights[] = {0.0,0.0,0.0};
      frame_1_grid.rowHeights = frame_1_rowHeights;
      frame_1_grid.columnWidths = frame_1_columnWidths;
      frame_1_grid.rowWeights = frame_1_rowWeights;
      frame_1_grid.columnWeights = frame_1_columnWeights;

      label_1 = new Label();
      label_1.setText("Root");
      this.add(label_1);

      entry_1 = new TextField(12);
      this.add(entry_1);

      label_2 = new Label();
      label_2.setText("Slot");
      this.add(label_2);

      entry_2 = new TextField(12);
      this.add(entry_2);

      frame_1 = new Panel();
      this.add(frame_1);

      radiobutton_3 = new ActiveCheckbox("", default_group, true);
      radiobutton_3.setLabel("Values");
      frame_1.add(radiobutton_3);

      radiobutton_4 = new ActiveCheckbox("", default_group, false);
      radiobutton_4.setLabel("Non-Values");
      frame_1.add(radiobutton_4);

      button_4 = new ActiveButton("");
      button_4.setLabel("Apply");
      this.add(button_4);

      frame_3 = new Panel();
      this.add(frame_3);

      button_3 = new ActiveButton("");
      button_3.setLabel("<");
      frame_3.add(button_3);

      button_2 = new ActiveButton("");
      button_2.setLabel(">");
      frame_3.add(button_2);

      listbox_1 = new List(4,false);
      this.add(listbox_1);

      listbox_2 = new List(4,false);
      this.add(listbox_2);

      listbox_3 = new List(4,false);
      this.add(listbox_3);

      listbox_4 = new List(4,false);
      this.add(listbox_4);

      // Geometry management
      GridBagConstraints con = new GridBagConstraints();
      reset(con);
      con.gridx = 2;
      con.gridy = 4;
      con.anchor = GridBagConstraints.EAST;
      con.fill = GridBagConstraints.NONE;
      grid.setConstraints(frame_3, con);

      reset(con);
      con.gridx = 1;
      con.gridy = 3;
      con.gridwidth = 2;
      con.anchor = GridBagConstraints.CENTER;
      con.fill = GridBagConstraints.NONE;
      grid.setConstraints(frame_1, con);

      reset(con);
      con.gridx = 1;
      con.gridy = 1;
      con.anchor = GridBagConstraints.EAST;
      con.fill = GridBagConstraints.NONE;
      grid.setConstraints(label_1, con);

      reset(con);
      con.gridx = 1;
      con.gridy = 1;
      con.anchor = GridBagConstraints.CENTER;
      con.fill = GridBagConstraints.NONE;
      frame_3_grid.setConstraints(button_3, con);

      reset(con);
      con.gridx = 1;
      con.gridy = 1;
      con.anchor = GridBagConstraints.CENTER;
      con.fill = GridBagConstraints.NONE;
      frame_1_grid.setConstraints(radiobutton_3, con);

      reset(con);
      con.gridx = 2;
      con.gridy = 1;
      con.anchor = GridBagConstraints.CENTER;
      con.fill = GridBagConstraints.NONE;
      frame_1_grid.setConstraints(radiobutton_4, con);

      reset(con);
      con.gridx = 2;
      con.gridy = 1;
      con.anchor = GridBagConstraints.CENTER;
      con.fill = GridBagConstraints.NONE;
      frame_3_grid.setConstraints(button_2, con);

      reset(con);
      con.gridx = 2;
      con.gridy = 1;
      con.anchor = GridBagConstraints.CENTER;
      con.fill = GridBagConstraints.NONE;
      grid.setConstraints(entry_1, con);

      reset(con);
      con.gridx = 4;
      con.gridy = 1;
      con.gridwidth = 5;
      con.gridheight = 4;
      con.anchor = GridBagConstraints.CENTER;
      con.fill = GridBagConstraints.BOTH;
      grid.setConstraints(listbox_1, con);

      reset(con);
      con.gridx = 10;
      con.gridy = 1;
      con.gridwidth = 5;
      con.gridheight = 4;
      con.anchor = GridBagConstraints.CENTER;
      con.fill = GridBagConstraints.BOTH;
      grid.setConstraints(listbox_2, con);

      reset(con);
      con.gridx = 16;
      con.gridy = 1;
      con.gridwidth = 5;
      con.gridheight = 4;
      con.anchor = GridBagConstraints.CENTER;
      con.fill = GridBagConstraints.BOTH;
      grid.setConstraints(listbox_3, con);

      reset(con);
      con.gridx = 22;
      con.gridy = 1;
      con.gridwidth = 5;
      con.gridheight = 4;
      con.anchor = GridBagConstraints.CENTER;
      con.fill = GridBagConstraints.BOTH;
      grid.setConstraints(listbox_4, con);

      reset(con);
      con.gridx = 1;
      con.gridy = 2;
      con.anchor = GridBagConstraints.EAST;
      con.fill = GridBagConstraints.NONE;
      grid.setConstraints(label_2, con);

      reset(con);
      con.gridx = 2;
      con.gridy = 2;
      con.anchor = GridBagConstraints.CENTER;
      con.fill = GridBagConstraints.NONE;
      grid.setConstraints(entry_2, con);

      reset(con);
      con.gridx = 1;
      con.gridy = 4;
      con.anchor = GridBagConstraints.CENTER;
      con.fill = GridBagConstraints.NONE;
      grid.setConstraints(button_4, con);

      // Resize behavior management and parent heirarchy
      frame_3.setLayout(frame_3_grid);
      setLayout(grid);
      frame_1.setLayout(frame_1_grid);
      //*********** END SpecJava Generated Code **********

      // Initialize BrowserRow variables with the UI objects created
      // by the generated code.
      lboxes[0] = listbox_1;
      lboxes[1] = listbox_2;
      lboxes[2] = listbox_3;
      lboxes[3] = listbox_4;
      root_field = entry_1;
      slot_field = entry_2;
      values = (ActiveCheckbox)radiobutton_3;
      non_values = (ActiveCheckbox)radiobutton_4;
      apply = (ActiveButton)button_4;
      left = (ActiveButton)button_3;
      right = (ActiveButton)button_2;
      this.frame_1 = frame_3;
   }

   // ********** BEGIN SpecJava Generated Code **********
   private void reset(GridBagConstraints con) {
      con.gridx = GridBagConstraints.RELATIVE;
      con.gridy = GridBagConstraints.RELATIVE;
      con.gridwidth = 1;
      con.gridheight = 1;
 
      con.weightx = 0;
      con.weighty = 0;
      con.anchor = GridBagConstraints.CENTER;
      con.fill = GridBagConstraints.NONE;
 
      con.insets = new Insets(0, 0, 0, 0);
      con.ipadx = 0;
      con.ipady = 0;
   }
   // ********** END SpecJava Generated Code **********

//   public void paint(Graphics g)
//   {
//      super.paint(g);
//      Graphics g2 = getParent().getGraphics();
//      Point p2 = location();
//      Point p = frame_1.location();
//      Dimension d = frame_1.size();
//      g2.draw3DRect(p2.x - 2, p2.y - 2, 
//                   p.x + d.width + 4, p.y + d.height + 4, true);
//   }

   public boolean handleEvent(Event e) {

      if (e.id == Event.ACTION_EVENT)
      {
         if (e.target == apply)
         {
            handleApply();
         }
         else if (e.target == left)
         {
            if (display_start_level > 0)
            {
               --display_start_level;
               updateDisplay(0);
            }
         }
         else if (e.target == right)
         {
            if (display_start_level + num_levels < tree.numRealizedLevels())
            {
               ++display_start_level;
               updateDisplay(0);
            }
         }
	 // Double click on a LIST generates an ACTION event - should display an object
	 else 
	 {
	   // Figure out which list box was the recipient of the event
	   // and display accordingly
	   //
	   LispValue sel_elem;
	   int i;
	   for (i = 0; (i < num_levels) && (lboxes[i] != e.target); ++i) ;
	   if (i >= num_levels)
	     return super.handleEvent(e);
	   else
	   {
	     sel_elem = tree.elementAt(display_start_level + i,
				       lboxes[i].getSelectedIndex(), 0);
	     if (sel_elem instanceof AlgyFrame)
	     {
	       Amaze.viewFrame(sel_elem.toString());
	       return true;
	     }
	   }
	 }
      }
      else if (e.id == Event.LIST_SELECT)
      {
	// Figure out which list box was the recipient of the event
	// and update tree accordingly 
	LispValue sel_elem;
         int i;
         for (i = 0; lboxes[i] != e.target; ++i) ;
         sel_elem = tree.elementAt(display_start_level + i,
                                   lboxes[i].getSelectedIndex(), 0);
         if (sel_elem instanceof AlgyFrame)
         {
            tree.setSelectedElem(display_start_level + i,
                                 lboxes[i].getSelectedIndex(), 0);
            // Need to scroll?
            if (i == num_levels - 1 &&
                display_start_level + num_levels < tree.numRealizedLevels())
            {
               ++display_start_level;
               updateDisplay(0);
            }
            else                      // No scrolling
               updateDisplay(i+1);
         }
         return true;
      }
      else if (e.id == Event.KEY_RELEASE &&
               ((char)e.key == '\r' || (char)e.key == '\n'))
      {
         if (e.target == root_field)
            root_field.nextFocus();
         else if (e.target == slot_field)
            handleApply();
         else
            return super.handleEvent(e);
         return true;
      }
      else if (e.id == Event.GOT_FOCUS)
      {
         if (e.target == root_field)
            root_field.selectAll();
         else if (e.target == slot_field)
            slot_field.selectAll();
         else
            return super.handleEvent(e);
         return true;
      };
   
      return super.handleEvent(e);
   }

   public long getUpdateTime() { return time_of_last_update; }

   private void handleApply()
   {
      // Don't do anything if either of the root or slot fields contain
      // nothing
      if (root_field.getText().equals("") ||
          slot_field.getText().equals(""))
         return;
          
      // Retrieve named frames/slots and do error checks
      LispValue possible_roots = kb.objectsNamed(root_field.getText());
      if (possible_roots instanceof LispNil)
      {
//         System.err.println("ERROR: " + root_field.getText() +
//                            " doesn't name a frame.");

         if (error_dialog == null) initErrorDialog();
         error_dialog.setMsg("ERROR: " + root_field.getText() +
                             " does not name a frame.");
         error_dialog.show();
         return;
      }
      LispValue possible_slots = kb.objectsNamed(slot_field.getText());
      if (possible_slots instanceof LispCons)
         // Check that we actually got a slot in the list
         for (; possible_slots instanceof LispCons && 
                 !(possible_slots.car() instanceof AlgySlot);
              possible_slots = possible_slots.cdr()) ;
      if (possible_slots instanceof LispNil)
      {
//         System.err.println("ERROR: " + slot_field.getText() +
//                            " doesn't name a slot.");
         if (error_dialog == null) initErrorDialog();
         error_dialog.setMsg("ERROR: " + slot_field.getText() +
                             " does not name a slot.");
         error_dialog.show();
         return;
      }

      // Error tests passed, set up the tree.
      tree.clearTree();
      tree.setDefaultSlot((AlgySlot)(possible_slots.car()));
      tree.setDefaultFacet(
         values.getState() ? KBManager.VALUE : KBManager.N_VALUE);
      for (LispValue tmp = possible_roots; tmp instanceof LispCons;
           tmp = tmp.cdr())
         tree.addRoot(tmp.car());
      if (((LispInteger)(possible_roots.length())).getValue() == 1)
         tree.setSelectedElem(0, 0, 0);
      // Initialize display
      display_start_level = 0;
      updateDisplay(0);
   }
   
   private void updateDisplay(int starting_listbox)
   {
      int i;
      // Clear the out of date part of display
      for (i = starting_listbox; i < num_levels; ++i) lboxes[i].clear();

      // Add new stuff to display
      i = starting_listbox;
      Enumeration e = tree.levelsEnumeration(
         display_start_level + starting_listbox, 
         (tree.numRealizedLevels() - display_start_level > num_levels) ?
         display_start_level + num_levels - 1 :
         tree.numRealizedLevels() - 1);
      TreeLevel lev;
      int sel_ndxes[];
      while (e.hasMoreElements())
      {
         lev = (TreeLevel)e.nextElement();
         for (int j = 0; j < lev.numNodes(); ++j)
         {
            String s = "";
            LispValue elem;
            for (int k = 0; k < lev.elemsPerNode(); ++k)
            {
               elem = lev.elementAt(j,k);
               if (k != 0) s += ", ";
               if (elem instanceof AlgyFrame)
               {
                  String tmp = ((AlgyFrame)elem).getPublicName().toString();
                  s += tmp.substring(1, tmp.length() - 1);
               }
               else
                  s += elem.toString();
            }
            lboxes[i].addItem(s);
         }
         sel_ndxes = lev.getSelectedElemIndexes();
         if (sel_ndxes[0] >= 0) 
         {
            lboxes[i].select(sel_ndxes[0]);
            lboxes[i].makeVisible(sel_ndxes[0]);
         }
         ++i;
      }

      // Note update time
      time_of_last_update = System.currentTimeMillis();
   }

   private static void initErrorDialog()
   {
      // For some reason we have to pass in a long bogus message
      // during construction because calling error_dialog.setMsg()
      // doesn't resize the window!
      error_dialog = new MsgDialog(
         error_dialog_parent, "Error", 
         "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
      error_dialog.setTitle("Error");
   }
   
}
