/*****************************************************************************
 **                          Browser for Algernon                           **
 *****************************************************************************/

package amaze.browser;

import java.awt.*;
import java.applet.Applet;

class WordTree 
{
   String word;
   int ndx;
   int size;
   WordTree[] subtrees;
   
public WordTree(String _word, int _size)
{
   word = _word;
   size = _size;
   ndx = 0;
   subtrees = new WordTree[size];
}
   
public void add(WordTree tree)
{
   subtrees[ndx] = tree;
   ++ndx;
}

}

class FrameList extends List 
{
   int row;
   int col;
   WordTree root;
   AlgyBrowser parent;

public FrameList(int _row, int _col, AlgyBrowser _parent)
{
   super(5, false);
   row = _row;
   col = _col;
   parent = _parent;
}

public void clearroot()
{
   if (root != null) {
      if (root.size != 0) clear();
      root = null;
   }
}

public void setroot(WordTree tree)
{
   if (root != null && root.size != 0) clear();
   root = tree;

   for (int i = 0; i < root.size; ++i) 
      addItem(root.subtrees[i].word);
}
      
public boolean handleEvent(Event event) 
{
   if (event.id == (Event.ACTION_EVENT)) 
      return parent.process_list_event((FrameList)event.target);
   else
      return super.handleEvent(event);
}
      
}

public class AlgyBrowser extends Applet 
{
   private FrameList[][] _lists;
   WordTree top;
   final int ROWS = 3;
   final int COLS = 4;
   
public void init() 
{
   int i, j;

   top = new WordTree("top", 1);
   WordTree root = new WordTree("root", 3);
   WordTree t1 = new WordTree("t1", 2);
   WordTree t2 = new WordTree("t2", 1);
   WordTree t3 = new WordTree("t3", 0);
   WordTree t4 = new WordTree("t4", 0);
   WordTree t5 = new WordTree("t5", 3);
   WordTree t6 = new WordTree("t6", 0);
   WordTree t7 = new WordTree("t7", 0);
   WordTree t8 = new WordTree("t8", 0);
   WordTree t9 = new WordTree("t9", 0);
   top.add(root);
   root.add(t1);
   root.add(t2);
   root.add(t3);
   t1.add(t4);
   t1.add(t5);
   t2.add(t6);
   t5.add(t7);
   t5.add(t8);
   t5.add(t9);
   
   this.setBackground(Color.cyan);

   setLayout(new GridLayout(ROWS, COLS));
   _lists = new FrameList[ROWS][COLS];
   
   for (i = 0; i < ROWS; ++i) 
   {
      for (j = 0; j < COLS; ++j) 
      {
         _lists[i][j] = new FrameList(i, j, this);
         add(_lists[i][j]);
      }
      _lists[i][0].setroot(top);
   }
}

public boolean process_list_event(FrameList l)
{
   int ndx = _lists[l.row][l.col].getSelectedIndex();
   
   if (ndx != -1) 
   {
      int i;
      for (i = l.col + 1; i < COLS; ++i)
         _lists[l.row][i].clearroot();
      _lists[l.row][l.col + 1].setroot(_lists[l.row][l.col].root.subtrees[ndx]);
   }
   
   // This next line is a hack that gets the scroll bars on the list
   // boxes to appear correctly when items are added.  Don't know what
   // gives here.
   _lists[l.row][l.col + 1].addNotify();
   return true;
}

}

   

