#!/lusr/bin/perl

$child = open(PIPEOUT, "|-");

defined($child) || die "Couldn't fork child process: $!";

sub killall {
    kill("TERM", $child);
    exit(0);
}

$SIG{'PIPE'} = 'killall';
$SIG{'CHLD'} = 'killall';

if ($child != 0) {
    # Parent
    select(PIPEOUT);
    close(STDOUT);
    $| = 1;
    while (1) {
        read(STDIN, $c, 1) || killall();
        print(PIPEOUT $c) || killall();
    }
}
else {
    # Child
    exec '/p/bin/java', '-classpath', $ARGV[0], 
         "-DALGY.HOME=$ARGV[1]", 'ioserver.GuiServer';
}
    
