;;;; -*- Mode:Lisp; Package:USER; Syntax:COMMON-LISP; Base:10 -*-

(in-package :user)

;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; Copyright (c) 1997 by Micheal Scott Hewett
;;;
;;; This code may be used by anyone for any project, but may not
;;; be sold in source or object form without permission.
;;; If in doubt, follow the GNU "copyleft" guidelines.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; (Contact: hewett@cs.utexas.edu or hewett@cs.stanford.edu)
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

;;; ********************************************************************
;;;
;;; test.lisp   -  Test file for the Algy I/O library
;;;
;;; Mike Hewett   16 January 1997
;;;
;;; This thoroughly tests all the interface routines.  Load the
;;; I/O library first.
;;;
;;; ********************************************************************


;;; (load-algy-library "io")
;;;
;;; I'm toying with defining (requires-kb "kb-name") for KBs.
;;; Maybe we need (requires-lib ...) for Libraries.


(defun test-gui ()

  (unwind-protect
      (progn (algy-io :OPEN)    ;; Start the server
	     (test))
    (algy-io :CLOSE)            ;; Close the server
    )
  )
  

(defun test ()

  (let ((answer     NIL)
	(min        -35.3)
	(max         62.1)
	(log-window nil)
	)

    (setq log-window (algy-open-log "Test Session Transcript"))
    (algy-log log-window "ALGY-OPEN-LOG~%")
    (algy-log log-window "~%This program tests the Algernon GUI Library.~%")
    (algy-log log-window "~%For more information, see:~%")
    (algy-log log-window "        <http://www.cs.utexas.edu/users/qr/algy/io-library.html>~2%")

    (algy-log log-window "Y-OR-N-P~%")
    (if (algy-y-or-n-p "Is it a sunny day? " )
	(format *standard-output* "~%It's a sunny day!")
      (format *standard-output* "~%Boo hoo, it's not a sunny day..."))

    (algy-log log-window "SHOW-MESSAGE with 3-second timeout.~%")
    (algy-show-message 3 "Starting test #~D" 2)

    (algy-log log-window "SHOW-TEXT~%")
    (algy-show-text "Here's my response:" "It is~%sunny outside,~%yes?~%")

    (algy-log log-window "READ-NUMBER (integer)~%")
    (setq answer (algy-read-number "What's your favorite ~A? " "integer"))
    (format *standard-output* "~%Your favorite integer is ~D" answer)

    (algy-log log-window "READ-NUMBER (float)~%")
    (setq answer (algy-read-number "What's your favorite ~A? " "real number"))
    (format *standard-output* "~%Your favorite real number is ~D." answer)

    (algy-log log-window "READ-NUMBER-WITH-BOUNDS~%")
    (setq answer
      (algy-read-number-with-bounds
       min max
       "Give me a number between ~D and ~D " min max))
    (format *standard-output* "~%The number is ~D." answer)

    (algy-log log-window "SHOW-MESSAGE with no timeout.~%")
    (algy-show-message 0 "Check the status printed in the~%LISP window.")

    (algy-log log-window "SHOW-MESSAGE with 2-second timeout.~%")
    (algy-show-message 2 "Let me show you the THINGS object.")

    (algy-log log-window "SHOW-FRAME~%")
    (algy-show-frame 'things)

    (algy-log log-window "STATUS~%")
    (algy-io :STATUS)         ;; Print the status  

    (algy-log log-window "READ-STRING~%")
    (setq answer
      (algy-read-string "Enter your full name: "))
    (format *standard-output* "~%Ha ha!  Your name is ~A!" answer)

    (algy-log log-window "STATUS~%")
    (algy-io :STATUS)         ;; Print the status  
  
    (algy-log log-window "READ-LIST~%")
    (setq answer
      (algy-read-list "Type a list of one or more colors (including parentheses): "))
    (format *standard-output* "~%The colors you entered are:~{ ~A~}" answer)

    (algy-log log-window "CHOOSE~%")
    (setq answer
      (algy-choose '(Planes Trains Automobiles)
		   "Select a mode of ~A: " 'transportation))
    (format *standard-output* "~%You want to go by ~A?" answer)

    (algy-log log-window "CHOOSE with labels~%")
    (setq answer
      (algy-choose '((Dogs    . "Canines")
		     (Cats    . "Felines")
		     (Birds   . "Aves")
		     (Snakes  . "Squamatas")
		     (Turtles . "Chelonias"))
		   "What is your favorite type of pet?"))
    (format *standard-output* "~%You like ~A?!" answer)

    (algy-log log-window "SHOW-TEXT~%")
    (algy-show-text "My response" "Hey, I don't~%know what~%a ~D is!~%" answer)

    (algy-log log-window "CHOOSE-MULTIPLE~%")
    (setq answer
      (algy-choose-multiple '("Viral" "Bacterial" "Infectious")
		   "Select one or more KBs:"))
    (format *standard-output* "~%Okay, I'll use the KBS named~{ ~A~}"
	    answer)

    (algy-io :STATUS)         ;; Print the status

    (algy-log log-window "Y-OR-N-P~%")
    (algy-y-or-n-p "Are you done?")

    (algy-log log-window "RESET~%")
    (algy-io :RESET)

;;    (algy-close-log log-window)     ;; Log windows don't close with RESET.

    (algy-y-or-n-p "I'm done...can I quit now?")
    )
  )



(format t "~2%;; GUI LIBRARY TEST PROGRAM:  Run (test) or (test-gui)~2%")
