// ===================================================================
// Copyright (c) 1997, All rights reserved, by Micheal Hewett
//
// This software is free for educational and non-profit use.
// Any for-profit use must be governed by a license available
// from the author, who can be contacted via email at 
// "hewett@cs.stanford.edu"
//
// ===================================================================
//
//  ImageDialog.java  - A dialog that displays an image, such as 
//                      used in an About... dialog
//
//  14 Feb 1997
//
// -------------------------------------------------------------------

package lib.display;

import java.applet.*;
import java.awt.*;
import java.io.*;
import java.net.*;


/**
 * AboutBoxDialog displays an image in a non-modal frame,
 * and by default closes when the mouse is clicked on it.
 *
 * Example:
 * <pre>
 *   AboutBoxDialog d = new AboutBoxDialog("About Netbake", "http://netbake.com/pics/NetbakeAboutBox.jpg");
 *   d.move(w, h);
 *   d.show();
 * </pre>
 * @see java.awt.Frame
 * @see java.awt.Dialog
 * @see java.net.URL
 * @author  Micheal S. Hewett    hewett@cs.utexas.edu
 * @date    Fri Feb 14 10:34:08 1997
 * @version 1.0
 *
 */
public class AboutBoxDialog extends Frame
{
  Image image;
  
  public AboutBoxDialog(String title, URL AboutBoxImageLocation)
  {
    super(title);  // Initialize frame.

    ImageLabel  l = new ImageLabel(AboutBoxImageLocation);
    
    setResizable(false);
    setLayout(new FlowLayout());
    add(l);
    pack();
  }

  public void finalize() throws Throwable { image.flush(); super.finalize(); }
    
  public boolean handleEvent(Event e)
  {
    if ((e.id == Event.MOUSE_UP)
        || (e.id == Event.WINDOW_DESTROY))
    {
      this.hide();
      return true;
    }
    else
      return super.handleEvent(e);
  }
}

