/*****************************************************************************
 **                           Class ActiveButton                            **
 *****************************************************************************/
//    File: ActiveButton.java
// Descrip: For whatever reason, the AWT Button doesn't respond to enter
//          returns or linefeed keypress events, so this is just a simple
//          extension to java.awt.Button to enable that functionality.
//
// History: Wed Jan 15 22:17:16 1997 created by Spencer Bishop
// $Id$
/*****************************************************************************/

package lib.display;

import java.awt.*;

/** Description needed! */
public class ActiveButton extends Button
{
   public ActiveButton(String label) { super(label); }

   public boolean handleEvent(Event e)
   {
      if (e.id == Event.KEY_RELEASE && 
          ((char)e.key == '\r' || (char)e.key == '\n')) 
      {
         e.id = Event.ACTION_EVENT;
         e.target = this;
         e.arg = getLabel();
         return super.handleEvent(e);
      }
      else
         return super.handleEvent(e);
   }
}
