/*****************************************************************************
 **                          Class ActiveCheckbox                           **
 *****************************************************************************/
//    File: ActiveCheckbox.java
// Descrip: For whatever reason, the AWT Checkbox doesn't respond to enter
//          returns or linefeed keypress events, so this is just a simple
//          extension to java.awt.Checkbox to enable that functionality.
//
// History: Wed Jan 15 22:17:16 1997 created by Spencer Bishop
// $Id$
/*****************************************************************************/

package lib.display;

import java.awt.*;

/** Description needed! */
public class ActiveCheckbox extends Checkbox
{
   public ActiveCheckbox(String label, CheckboxGroup grp, boolean on)
   { super(label, grp, on); }

   public boolean handleEvent(Event e)
   {
      if (e.id == Event.KEY_PRESS && 
          ((char)e.key == '\r' || (char)e.key == '\n')) 
      {
         setState(!getState());
         return true;
      }
      else
         return super.handleEvent(e);
   }
}
