/*****************************************************************************
 **                            Class LogWindow                              **
 *****************************************************************************/
//    File: LogWindow.java
// Descrip: Supports the creation and update of a log window to show 
//          incremental data from some process or whatever.
//
// History: Fri Feb 14 16:00:33 1997 created by Spencer Bishop
// $Id$
/*****************************************************************************/

package lib.display;

import java.awt.*;

/**
 * <ul>
 *  <li> open-log <pre>
 *       open-log<SP><ID><SP><TITLE><NULL>
 *       </pre>
 *  <li> clear-log <pre>
 *       clear-log<SP><ID><SP><LOG ID><NULL>
 *       </pre>
 *  <li> log <pre>
 *       log<SP><ID><SP><LOG ID><SP><TEXT W/ NL><NULL>
 *       </pre>
 *  <li> close-log <pre>
 *       clear-log<SP><ID><SP><LOG ID><NULL>
 *       </pre>
 * </ul>
 */
public class LogWindow extends Frame
{
   private static int next_ID = 0;

   private TextArea textarea;
   private int create_ID;      // ID of command that created log window
   private int log_ID;         /* ID used to identify this log window in
                                * commands to add/clear text or close log */

   public LogWindow(int ID, String title)
   {
      super(title);
      
      create_ID = ID;
      log_ID = next_ID; ++next_ID;
      
      setLayout(new BorderLayout());
      textarea = new TextArea(45, 60);
      textarea.setEditable(false);
      textarea.setFont(new Font("Courier", Font.PLAIN, 12));
      add("Center", textarea);

      // Notify client of log window ID
      System.out.println("(" + create_ID + " " + log_ID + ")");
      
      WinPosition.showWin(this);
   }

   public void killWindow() { dispose(); }

   public int logID() { return log_ID; }

   public void clear() { textarea.setText(""); }

   public void appendText(String s) { textarea.appendText(s); }
}
